/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Jan 30, 2004
 * Time: 2:14:51 PM
 */
package com.atlassian.confluence.rpc.xmlrpc;

import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.SecureRpc;

import java.util.Hashtable;
import java.util.Vector;

/*
  NOTE:

     DO NOT add any methods to this interface that return void! XML-RPC can't handle it. Make them
     return boolean (true) instead.
 */
public interface ConfluenceXmlRpcHandler extends SecureRpc
{
    // AUTHENTICATION
    String login(String username, String password) throws RemoteException;

    boolean logout(String token) throws RemoteException;

    // CONTENT
    Vector getPages(String token, String spaceKey) throws RemoteException;

    Hashtable getPage(String token, String pageId) throws RemoteException;

    Hashtable getPage(String token, String spaceKey, String pageTitle) throws RemoteException;

    Vector getPermissions(String token, String spaceKey) throws RemoteException;
    Vector getPermissionsForUser(String token, String spaceKey, String userName) throws RemoteException;

    String renderContent(String token, String spaceKey, String pageId, String newContent) throws RemoteException;

    String renderContent(String token, String spaceKey, String pageId, String newContent, Hashtable renderParameters) throws RemoteException;

    Hashtable storePage(String token, Hashtable pageStruct) throws RemoteException;

    Boolean removePage(String token, String pageId) throws RemoteException;

    Vector search(String token, String query, int maxResults) throws RemoteException;
    Vector search(String token, String query, Hashtable params, int maxResults) throws RemoteException;

    Vector getPageHistory(String token, String pageId) throws RemoteException;

    Vector getPagePermissions(String token, String pageId) throws RemoteException;

    Vector getBlogEntries(String token, String spaceKey) throws RemoteException;

    Hashtable getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException;

    Hashtable getBlogEntry(String token, String blogEntryId) throws RemoteException;

    Hashtable storeBlogEntry(String token, Hashtable blogEntryStruct) throws RemoteException;

    Vector getComments(String token, String pageId) throws RemoteException;
    Hashtable getComment(String token, String commentId) throws InvalidSessionException, RemoteException;
    Hashtable addComment(String token, Hashtable comment) throws InvalidSessionException, NotPermittedException, RemoteException;
    boolean removeComment(String token, String commentId) throws InvalidSessionException, NotPermittedException, RemoteException;
    Vector getAncestors(String token, String pageId) throws RemoteException;
    Vector getChildren(String token, String pageId) throws RemoteException;
    Vector getDescendents(String token, String pageId) throws RemoteException;
    Vector getAttachments(String token, String pageId) throws RemoteException;

    // ATTACHMENTS
    Hashtable addAttachment(String token, String contentId, Hashtable attachment, byte[] attachmentData) throws RemoteException, NotPermittedException;
    Hashtable getAttachment(String token, String contentId, String fileName, String version) throws RemoteException, NotPermittedException;
    byte[] getAttachmentData(String token, String contentId, String fileName, String version) throws RemoteException, NotPermittedException;
    boolean removeAttachment(String token, String contentId, String fileName) throws RemoteException, NotPermittedException;
    boolean moveAttachment(String token, String originalContentId, String originalFileName, String newContentId, String newFileName) throws RemoteException, NotPermittedException;

    // SPACE RETRIEVAL
    Vector getSpaces(String token) throws RemoteException;
    Hashtable getSpace(String token, String spaceKey) throws RemoteException;

    // SPACE ADMINISTRATION
    Hashtable addSpace(String token, Hashtable space) throws RemoteException;
    Hashtable addPersonalSpace(String token, Hashtable space, String username) throws RemoteException;
    boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException;
    Boolean removeSpace(String token, String spaceKey) throws RemoteException;
    String exportSpace(String token, String spaceKey, String exportType) throws RemoteException;
    boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException;
    boolean addPermissionsToSpace(String token, Vector permissions, String remoteEntityName, String spaceKey) throws RemoteException;
    boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException;
    boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException;
    boolean addAnonymousPermissionsToSpace(String token, Vector permissions, String spaceKey) throws RemoteException;
    boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException;
    String[] getSpaceLevelPermissions(String token) throws RemoteException;

    // ADMINISTRATION
    String exportSite(String token, boolean exportAttachments) throws RemoteException;
    Hashtable getServerInfo(String token) throws RemoteException;
    boolean flushIndexQueue(String token) throws RemoteException;
    boolean clearIndexQueue(String token) throws RemoteException;

    /* Users API */
    // See ConfluenceSoapService for documentation
    // Groups
    Vector getGroups(String token) throws RemoteException;
    boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException;
    boolean addGroup(String token, String groupname) throws RemoteException;
    boolean removeGroup(String token, String groupname, String defaultGroupName) throws RemoteException;
    boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException;
    Vector getUserGroups(String token, String username) throws RemoteException;
    boolean addUserToGroup(String token, String username, String groupname) throws RemoteException;
    boolean removeUserFromGroup(String token, String username, String groupname) throws RemoteException;

    // Users
    Hashtable getUser(String token, String username) throws RemoteException;
    boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException;
    boolean addUser(String token, Hashtable remoteUser, String password) throws RemoteException;
    boolean removeUser(String token, String username) throws RemoteException;
    boolean editUser(String token, Hashtable remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException;
    boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException;
    boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException;
    Vector getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException;
    boolean setUserInformation(String token, Hashtable userInfo) throws NotPermittedException, InvalidSessionException, RemoteException;
    Hashtable getUserInformation(String token, String username) throws InvalidSessionException, RemoteException;
    boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException;
    boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException;
    boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws RemoteException;

    /* Labels Remote API */
    // See ConfluenceSoapService for documentation
    Vector getLabelsById(String token, String objectId) throws RemoteException;
    Vector getMostPopularLabels(String token, int maxCount) throws RemoteException;
    Vector getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws RemoteException;
    Vector getLabelContentById(String token, String labelId) throws RemoteException;
    Vector getLabelContentByName(String token, String labelName) throws RemoteException;
    Vector getLabelContentByObject(String token, Hashtable labelObject) throws RemoteException;
    Vector getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException;
    Vector getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException;
    Vector getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException;
    Vector getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException;
    Vector getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException;
    Vector getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException;
    Vector getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException;

    boolean addLabelByName(String token, String labelName, String objectId) throws NotPermittedException, RemoteException;
    boolean addLabelById(String token, String labelId, String objectId) throws NotPermittedException, RemoteException;
    boolean addLabelByObject(String token, Hashtable labelObject, String objectId) throws NotPermittedException, RemoteException;
    boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException;

    boolean removeLabelByName(String token, String labelName, String objectId) throws NotPermittedException, RemoteException;
    boolean removeLabelById(String token, String labelId, String objectId) throws NotPermittedException, RemoteException;
    boolean removeLabelByObject(String token, Hashtable labelObject, String objectId) throws NotPermittedException, RemoteException;
    boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException;
}