/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 19, 2004
 * Time: 3:41:09 PM
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public interface SoapServiceHelper
{
    Space retrieveSpace(String spaceKey) throws RemoteException;

    AbstractPage retrieveAbstractPage(long pageId) throws RemoteException;

    Page retrievePage(String spaceKey, String pageTitle) throws RemoteException;

    /**
     * Retrieves the user with the given username
     *
     * @param username the username of the user
     * @return The User instance corresponding to the user
     * @throws RemoteException if the username is empty or null
     * @throws RemoteException if no User could be found for the username
     */
    User retrieveUser(String username) throws RemoteException;

    void assertCanAdministrate() throws RemoteException;

    void renamePage(Page page, String newName) throws RemoteException;

    /**
     * Determines if the current user can modify/edit the given object
     *
     * If the current user is a super-user, they will automatically pass this test
     *
     * @param obj the target object
     * @param typeDescription the type of object (e.g. "labels")
     * @throws NotPermittedException if the user lacks EDIT permission
     */
    void assertCanModifyObject(Object obj, String typeDescription) throws NotPermittedException;

    void assertCanModify(AbstractPage page) throws RemoteException;

    void assertCanRemove(AbstractPage page) throws RemoteException;

    void assertCanView(AbstractPage page)  throws RemoteException;

    void assertCanExport(Space space) throws RemoteException;

    void assertCanAdminister(Space space) throws RemoteException;

    void assertCanView(Space space) throws RemoteException;

    void assertCanCreateBlogPost(Space space) throws RemoteException;

    void assertCanCreatePage(Space space) throws RemoteException;
}