/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 19, 2004
 * Time: 4:10:24 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteUser
{
    String name;
    String fullname;
    String email;
    String url;

    public RemoteUser()
    {
    }

    public RemoteUser(User user)
    {
        this.name = user.getName();
        this.fullname = user.getFullName();
        this.email = user.getEmail();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + "/display/~" + GeneralUtil.urlEncode(name);
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getFullname()
    {
        return fullname;
    }

    public void setFullname(String fullname)
    {
        this.fullname = fullname;
    }

    public String getEmail()
    {
        return email;
    }

    public void setEmail(String email)
    {
        this.email = email;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteUser)) return false;

        final RemoteUser remoteUser = (RemoteUser) o;

        if (email != null ? !email.equals(remoteUser.email) : remoteUser.email != null) return false;
        if (fullname != null ? !fullname.equals(remoteUser.fullname) : remoteUser.fullname != null) return false;
        if (!name.equals(remoteUser.name)) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = name.hashCode();
        result = 29 * result + (fullname != null ? fullname.hashCode() : 0);
        result = 29 * result + (email != null ? email.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}