/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 2:03:24 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.spaces.Space;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteSpaceSummary
{
    String key;
    String name;
    String url;
    String type;

    public RemoteSpaceSummary()
    {
    }

    public RemoteSpaceSummary(Space space)
    {
        this.key = space.getKey();
        this.name = space.getName();
        this.type = space.getSpaceType().toString();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + "/display/" + space.getKey();
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getKey()
    {
        return key;
    }

    public void setKey(String key)
    {
        this.key = key;
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteSpaceSummary)) return false;

        final RemoteSpaceSummary remoteSpaceSummary = (RemoteSpaceSummary) o;

        if (!key.equals(remoteSpaceSummary.key)) return false;
        if (name != null ? !name.equals(remoteSpaceSummary.name) : remoteSpaceSummary.name != null) return false;
        if (!url.equals(remoteSpaceSummary.url)) return false;

        return true;
    }

    public int hashCode()
    {
        int result = key.hashCode();
        result = 29 * result + (name != null ? name.hashCode() : 0);
        result = 29 * result + url.hashCode();
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }

}