/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 1:55:15 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.WikiStyleRenderer;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteSpace extends RemoteSpaceSummary
{
    String description;
    long homePage;

    public RemoteSpace(Space space, WikiStyleRenderer renderer)
    {
        super(space);

        if (space.getHomePage() != null)
            this.homePage = space.getHomePage().getId();

        if (space.getDescription() != null && TextUtils.stringSet(space.getDescription().getContent()))
            this.description = renderer.convertWikiToXHtml(space.getDescription().toPageContext(), space.getDescription().getContent());
    }

    public RemoteSpace()
    {
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    public long getHomePage()
    {
        return homePage;
    }

    public void setHomePage(long homePage)
    {
        this.homePage = homePage;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteSpace)) return false;
        if (!super.equals(o)) return false;

        final RemoteSpace remoteSpace = (RemoteSpace) o;

        if (homePage != remoteSpace.homePage) return false;
        if (description != null ? !description.equals(remoteSpace.description) : remoteSpace.description != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (description != null ? description.hashCode() : 0);
        result = 29 * result + (int) (homePage ^ (homePage >>> 32));
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}