package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.GeneralUtil;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.StringTokenizer;

public class RemoteServerInfo
{
    private int majorVersion;
    private int minorVersion;
    private int patchLevel;
    private boolean developmentBuild;
    private String buildId;

    private String baseUrl;

    public RemoteServerInfo()
    {

        this.buildId = GeneralUtil.getBuildNumber();
        setVersion(GeneralUtil.getVersionNumber());
        this.baseUrl = BootstrapUtils.getBootstrapManager().getBaseUrl();
    }

    public int getMajorVersion()
    {
        return majorVersion;
    }

    public int getMinorVersion()
    {
        return minorVersion;
    }

    public int getPatchLevel()
    {
        return patchLevel;
    }

    public boolean isDevelopmentBuild()
    {
        return developmentBuild;
    }

    public String getBuildId()
    {
        return buildId;
    }

    public String getBaseUrl()
    {
        return baseUrl;
    }

    private void setVersion(String version)
    {
        if (version.endsWith("dev") || version.endsWith("DEV"))
            developmentBuild = true;

        StringTokenizer tok = new StringTokenizer(version, ".- ");

        majorVersion = nextNumber(tok);
        minorVersion = nextNumber(tok);
        patchLevel = nextNumber(tok);
    }

    private int nextNumber(StringTokenizer tok)
    {
        if (!tok.hasMoreTokens())
            return 0;

        try
        {
            return Integer.parseInt(tok.nextToken());
        }
        catch (NumberFormatException e)
        {
            developmentBuild = true;
            return 0;
        }
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}
