/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 5:14:13 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.renderer.util.RendererUtil;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteSearchResult
{
    private String type;
    private long id;
    private String title;
    private String url;
    private String excerpt;

    public RemoteSearchResult()
    {
    }

    public RemoteSearchResult(Addressable addressable)
    {
        setId(addressable.getId());
        setType(addressable.getType());
        setTitle(addressable.getRealTitle());
        if (addressable instanceof Attachment)
            setUrl(BootstrapUtils.getBootstrapManager().getBaseUrl() + ((Attachment)addressable).getDownloadPath());
        else
            setUrl(BootstrapUtils.getBootstrapManager().getBaseUrl() + addressable.getUrlPath());

        if (addressable instanceof Mail)
        {
            setExcerpt(((Mail)addressable).getExcerpt());
        }
        else if (addressable instanceof ContentEntityObject)
        {
            setExcerpt(RendererUtil.summarise(((ContentEntityObject)addressable).getContent()));
        }
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public void setExcerpt(String excerpt)
    {
        this.excerpt = excerpt;
    }

    public String getType()
    {
        return type;
    }

    public long getId()
    {
        return id;
    }

    public String getTitle()
    {
        return title;
    }

    public String getUrl()
    {
        return url;
    }

    public String getExcerpt()
    {
        return excerpt;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}