/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 2:45:09 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemotePageSummary extends AbstractRemotePageSummary
{
    long parentId;

    public RemotePageSummary()
    {
    }

    public RemotePageSummary(Page page)
    {
        super(page);
        if (page.getParent() != null)
            parentId = page.getParent().getId();
    }

    public long getParentId()
    {
        return parentId;
    }

    public void setParentId(long parentId)
    {
        this.parentId = parentId;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemotePageSummary)) return false;

        final RemotePageSummary remotePageSummary = (RemotePageSummary) o;

        if (id != remotePageSummary.id) return false;
        if (parentId != remotePageSummary.parentId) return false;
        if (space != null ? !space.equals(remotePageSummary.space) : remotePageSummary.space != null) return false;
        if (title != null ? !title.equals(remotePageSummary.title) : remotePageSummary.title != null) return false;
        if (url != null ? !url.equals(remotePageSummary.url) : remotePageSummary.url != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (int) (id ^ (id >>> 32));
        result = 29 * result + (int) (parentId ^ (parentId >>> 32));
        result = 29 * result + (space != null ? space.hashCode() : 0);
        result = 29 * result + (title != null ? title.hashCode() : 0);
        result = 29 * result + (url != null ? url.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}