/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 6, 2004
 * Time: 11:35:02 AM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.AbstractPage;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

public class RemotePageHistory
{
    private long id;
    private int version;
    private String modifier;
    private Date modified;

    public RemotePageHistory()
    {
    }

    public RemotePageHistory(AbstractPage page)
    {
        this.id = page.getId();
        this.version = page.getVersion();
        this.modifier = page.getLastModifierName();
        this.modified = new Date(page.getLastModificationDate().getTime());
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public int getVersion()
    {
        return version;
    }

    public void setVersion(int version)
    {
        this.version = version;
    }

    public String getModifier()
    {
        return modifier;
    }

    public void setModifier(String modifier)
    {
        this.modifier = modifier;
    }

    public Date getModified()
    {
        return modified;
    }

    public void setModified(Date modified)
    {
        this.modified = modified;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemotePageHistory)) return false;

        final RemotePageHistory remotePageHistory = (RemotePageHistory) o;

        if (id != remotePageHistory.id) return false;
        if (version != remotePageHistory.version) return false;
        if (modified != null ? !modified.equals(remotePageHistory.modified) : remotePageHistory.modified != null) return false;
        if (modifier != null ? !modifier.equals(remotePageHistory.modifier) : remotePageHistory.modifier != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (int) (id ^ (id >>> 32));
        result = 29 * result + version;
        result = 29 * result + (modifier != null ? modifier.hashCode() : 0);
        result = 29 * result + (modified != null ? modified.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}