/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 1:55:04 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Page;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

public class RemotePage extends RemotePageSummary
{
    Date created, modified;
    String creator, modifier, content, contentStatus;
    int version;
    boolean homePage;

    public RemotePage()
    {
    }

    public RemotePage(Page page)
    {
        super(page);

        this.content = page.getContent();
        this.version = page.getVersion();

        if (page.getCreationDate() != null)
            this.created = new Date(page.getCreationDate().getTime());

        if (page.getCreatorName() != null)
            this.creator = page.getCreatorName();

        if (page.getLastModificationDate() != null)
            this.modified = new Date(page.getLastModificationDate().getTime());

        if (page.getLastModifierName() != null)
            this.modifier = page.getLastModifierName();

        if (page.isCurrent())
            this.contentStatus = Page.CURRENT;
        else
            this.contentStatus = Page.DELETED;

        this.homePage = page.isHomePage();
    }

    public Date getCreated()
    {
        return created;
    }

    public void setCreated(Date created)
    {
        this.created = created;
    }

    public Date getModified()
    {
        return modified;
    }

    public void setModified(Date modified)
    {
        this.modified = modified;
    }

    public String getCreator()
    {
        return creator;
    }

    public void setCreator(String creator)
    {
        this.creator = creator;
    }

    public String getModifier()
    {
        return modifier;
    }

    public void setModifier(String modifier)
    {
        this.modifier = modifier;
    }

    public String getContent()
    {
        return content;
    }

    public void setContent(String content)
    {
        this.content = content;
    }

    public int getVersion()
    {
        return version;
    }

    public void setVersion(int version)
    {
        this.version = version;
    }

    public String getContentStatus()
    {
        return contentStatus;
    }

    public void setContentStatus(String contentStatus)
    {
        this.contentStatus = contentStatus;
    }

    public boolean isHomePage()
    {
        return homePage;
    }

    public void setHomePage(boolean homePage)
    {
        this.homePage = homePage;
    }

    public boolean isCurrent()
    {
        return Page.CURRENT.equals(this.contentStatus);
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemotePage)) return false;
        if (!super.equals(o)) return false;

        final RemotePage remotePage = (RemotePage) o;

        if (homePage != remotePage.homePage) return false;
        if (version != remotePage.version) return false;
        if (content != null ? !content.equals(remotePage.content) : remotePage.content != null) return false;
        if (created != null ? !created.equals(remotePage.created) : remotePage.created != null) return false;
        if (creator != null ? !creator.equals(remotePage.creator) : remotePage.creator != null) return false;
        if (modified != null ? !modified.equals(remotePage.modified) : remotePage.modified != null) return false;
        if (modifier != null ? !modifier.equals(remotePage.modifier) : remotePage.modifier != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (created != null ? created.hashCode() : 0);
        result = 29 * result + (modified != null ? modified.hashCode() : 0);
        result = 29 * result + (creator != null ? creator.hashCode() : 0);
        result = 29 * result + (modifier != null ? modifier.hashCode() : 0);
        result = 29 * result + (content != null ? content.hashCode() : 0);
        result = 29 * result + version;
        result = 29 * result + (homePage ? 1 : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}