/*
 * Created by IntelliJ IDEA.
 * User: Jeremy Higgs
 * Date: August 15th, 2005
 * Time: 3:37:00 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.labels.Label;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteLabel
{
    private String name;
    private String owner;
    private String namespace;
    protected long id;

    public RemoteLabel()
    {
        super();
    }

    public RemoteLabel(Label label)
    {
        super();

        this.id = label.getId();
        this.name = label.getName();
        this.owner = label.getOwner();
        this.namespace = label.getNamespace().toString();
    }

    // Accessor methods
    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getOwner()
    {
        return owner;
    }

    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public boolean equals(Object other)
    {
        if (!(other instanceof RemoteLabel))
            return false;

        RemoteLabel otherLabel = (RemoteLabel) other;
        if (getId() == 0 && otherLabel.getId() == 0)
            return this == otherLabel;

        return getId() == otherLabel.getId();
    }

    public int hashCode()
    {
        return (int) (id ^ (id >>> 32));
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getNamespace()
    {
        return namespace;
    }

    public void setNamespace(String namespace)
    {
        this.namespace = namespace;
    }
}