/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 12:57:08 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.setup.BootstrapUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

public class RemoteComment
{
    long id;
    long pageId;
    long parentId;
    Date created;
    String title, url, creator, content;

    public RemoteComment()
    {
        
    }

    public RemoteComment(Comment comment)
    {
        this.id = comment.getId();
        this.pageId = comment.getPage().getId();

        // If there's a comment parent, and they're on the same page, set the ID
        if (comment.getParent() != null && comment.getPage().equals(comment.getParent().getPage()))
            this.parentId = comment.getParent().getId();
        else
            this.parentId = 0;

        this.title = comment.getRealTitle();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + comment.getUrlPath();

        this.content = comment.getContent();

        if (comment.getCreationDate() != null)
            this.created = new Date(comment.getCreationDate().getTime());

        if (comment.getCreatorName() != null)
            this.creator = comment.getCreatorName();
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public long getPageId()
    {
        return pageId;
    }

    public void setPageId(long pageId)
    {
        this.pageId = pageId;
    }

    public Date getCreated()
    {
        return created;
    }

    public void setCreated(Date created)
    {
        this.created = created;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getCreator()
    {
        return creator;
    }

    public void setCreator(String creator)
    {
        this.creator = creator;
    }

    public String getContent()
    {
        return content;
    }

    public void setContent(String content)
    {
        this.content = content;
    }

    public long getParentId()
    {
        return parentId;
    }

    public void setParentId(long parentId)
    {
        this.parentId = parentId;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteComment)) return false;

        final RemoteComment remoteComment = (RemoteComment) o;

        if (id != remoteComment.id) return false;
        if (pageId != remoteComment.pageId) return false;
        if (content != null ? !content.equals(remoteComment.content) : remoteComment.content != null) return false;
        if (created != null ? !created.equals(remoteComment.created) : remoteComment.created != null) return false;
        if (creator != null ? !creator.equals(remoteComment.creator) : remoteComment.creator != null) return false;
        if (title != null ? !title.equals(remoteComment.title) : remoteComment.title != null) return false;
        if (url != null ? !url.equals(remoteComment.url) : remoteComment.url != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (int) (id ^ (id >>> 32));
        result = 29 * result + (int) (pageId ^ (pageId >>> 32));
        result = 29 * result + (created != null ? created.hashCode() : 0);
        result = 29 * result + (title != null ? title.hashCode() : 0);
        result = 29 * result + (url != null ? url.hashCode() : 0);
        result = 29 * result + (creator != null ? creator.hashCode() : 0);
        result = 29 * result + (content != null ? content.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}