package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.AbstractPage;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

public class RemoteBlogEntrySummary extends AbstractRemotePageSummary
{
    private Date publishDate;
    private String author;

    public RemoteBlogEntrySummary()
    {
        super();
    }

    public RemoteBlogEntrySummary(AbstractPage page)
    {
        super(page);
        if (page.getCreationDate() != null)
            publishDate = new Date(page.getCreationDate().getTime());
        author = page.getCreatorName();
    }

    public Date getPublishDate()
    {
        return publishDate;
    }

    public void setPublishDate(Date publishDate)
    {
        if (publishDate != null)
            this.publishDate = new Date(publishDate.getTime());
        else
            this.publishDate = null;
    }

    public String getAuthor()
    {
        return author;
    }

    public void setAuthor(String author)
    {
        this.author = author;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteBlogEntrySummary)) return false;

        final RemoteBlogEntrySummary remoteBlogEntrySummary = (RemoteBlogEntrySummary) o;

        if (author != null ? !author.equals(remoteBlogEntrySummary.author) : remoteBlogEntrySummary.author != null) return false;
        if (publishDate != null ? !publishDate.equals(remoteBlogEntrySummary.publishDate) : remoteBlogEntrySummary.publishDate != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (publishDate != null ? publishDate.hashCode() : 0);
        result = 29 * result + (author != null ? author.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}
