package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.BlogPost;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteBlogEntry extends RemoteBlogEntrySummary
{
    private String content;
    private int version;

    public RemoteBlogEntry()
    {
        super();
    }

    public RemoteBlogEntry(BlogPost blogPost)
    {
        super(blogPost);
        content = blogPost.getContent();
        version = blogPost.getVersion();
    }

    public String getContent()
    {
        return content;
    }

    public void setContent(String content)
    {
        this.content = content;
    }

    public int getVersion()
    {
        return version;
    }

    public void setVersion(int version)
    {
        this.version = version;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteBlogEntry)) return false;
        if (!super.equals(o)) return false;

        final RemoteBlogEntry remoteBlogEntry = (RemoteBlogEntry) o;

        if (content != null ? !content.equals(remoteBlogEntry.content) : remoteBlogEntry.content != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (content != null ? content.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}
