/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 12, 2004
 * Time: 1:05:30 PM
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.BootstrapUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

public class RemoteAttachment
{
    long id, pageId, fileSize;
    String title, fileName, contentType, creator, url;
    String comment;
    Date created;

    public RemoteAttachment()
    {
        // no arg constructor required.
    }

    public RemoteAttachment(Attachment attachment)
    {
        this.id = attachment.getId();
        this.pageId = attachment.getContent().getId();
        this.title = attachment.getRealTitle();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + attachment.getDownloadPath();

        this.fileName = attachment.getFileName();
        this.fileSize = attachment.getFileSize();
        this.contentType = attachment.getContentType();
        this.comment = attachment.getComment();

        if (attachment.getCreationDate() != null)
            this.created = new Date(attachment.getCreationDate().getTime());

        if (attachment.getCreatorName() != null)
            this.creator = attachment.getCreatorName();
    }

    /**
     * Use this constructor when creating an attachment to add
     */
    public RemoteAttachment(long contentId, String fileName, String contentType, String comment)
    {
        this.pageId = contentId;
        this.fileName = fileName;
        this.comment = comment;
        this.contentType = contentType;
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public long getPageId()
    {
        return pageId;
    }

    public void setPageId(long pageId)
    {
        this.pageId = pageId;
    }

    public long getFileSize()
    {
        return fileSize;
    }

    public void setFileSize(long fileSize)
    {
        this.fileSize = fileSize;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getFileName()
    {
        return fileName;
    }

    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    public String getContentType()
    {
        return contentType;
    }

    public void setContentType(String contentType)
    {
        this.contentType = contentType;
    }

    public String getCreator()
    {
        return creator;
    }

    public void setCreator(String creator)
    {
        this.creator = creator;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public Date getCreated()
    {
        return created;
    }


    public String getComment()
    {
        return comment;
    }

    public void setCreated(Date created)
    {
        this.created = created;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof RemoteAttachment)) return false;

        final RemoteAttachment remoteAttachment = (RemoteAttachment) o;

        if (fileSize != remoteAttachment.fileSize) return false;
        if (id != remoteAttachment.id) return false;
        if (pageId != remoteAttachment.pageId) return false;
        if (contentType != null ? !contentType.equals(remoteAttachment.contentType) : remoteAttachment.contentType != null) return false;
        if (created != null ? !created.equals(remoteAttachment.created) : remoteAttachment.created != null) return false;
        if (creator != null ? !creator.equals(remoteAttachment.creator) : remoteAttachment.creator != null) return false;
        if (fileName != null ? !fileName.equals(remoteAttachment.fileName) : remoteAttachment.fileName != null) return false;
        if (title != null ? !title.equals(remoteAttachment.title) : remoteAttachment.title != null) return false;
        if (url != null ? !url.equals(remoteAttachment.url) : remoteAttachment.url != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (int) (id ^ (id >>> 32));
        result = 29 * result + (int) (pageId ^ (pageId >>> 32));
        result = 29 * result + (int) (fileSize ^ (fileSize >>> 32));
        result = 29 * result + (title != null ? title.hashCode() : 0);
        result = 29 * result + (fileName != null ? fileName.hashCode() : 0);
        result = 29 * result + (contentType != null ? contentType.hashCode() : 0);
        result = 29 * result + (creator != null ? creator.hashCode() : 0);
        result = 29 * result + (url != null ? url.hashCode() : 0);
        result = 29 * result + (created != null ? created.hashCode() : 0);
        return result;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}