package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.GeneralUtil;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractRemotePageSummary
{
    long id;
    String space;
    String title;
    String url;
    int permissions;

    protected AbstractRemotePageSummary()
    {        
    }

    protected AbstractRemotePageSummary(AbstractPage page)
    {
        this.id = page.getId();
        if (page.getOriginalVersion() != null)
            this.space = ((AbstractPage)page.getOriginalVersion()).getSpace().getKey();
        else
            this.space = page.getSpace().getKey();

        this.title = page.getTitle();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + GeneralUtil.getPageUrl(page);
        this.permissions = page.getPermissions().size();
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public String getSpace()
    {
        return space;
    }

    public void setSpace(String space)
    {
        this.space = space;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getUrl()
    {
        return url;
    }

    public void setUrl(String url)
    {
        this.url = url;
    }

    public int getPermissions()
    {
        return permissions;
    }

    public void setPermissions(int permissions)
    {
        this.permissions = permissions;
    }

    public String toString()
    {
        return ToStringBuilder.reflectionToString(this);
    }
}
