/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 2:03:04 PM
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.pages.*;
import com.atlassian.confluence.rpc.soap.beans.*;
import com.atlassian.confluence.spaces.Space;

import java.util.List;

public class SoapUtils
{
    public static RemoteSpaceSummary[] getSpaceSummaries(List spaces)
    {
        RemoteSpaceSummary[] result = new RemoteSpaceSummary[spaces.size()];

        for (int i = 0; i < spaces.size(); i++)
        {
            result[i] = new RemoteSpaceSummary((Space) spaces.get(i));
        }

        return result;
    }

    public static RemotePageSummary[] getPageSummaries(List pages)
    {
        RemotePageSummary[] result = new RemotePageSummary[pages.size()];

        for (int i = 0; i < pages.size(); i++)
        {
            result[i] = new RemotePageSummary((Page) pages.get(i));
        }

        return result;
    }

    public static RemoteBlogEntrySummary[] getBlogEntrySummaries(List blogEntries)
    {
        RemoteBlogEntrySummary[] result = new RemoteBlogEntrySummary[blogEntries.size()];

        for (int i = 0; i < blogEntries.size(); i++)
        {
            result[i] = new RemoteBlogEntrySummary((BlogPost) blogEntries.get(i));
        }

        return result;
    }

    public static RemotePageHistory[] getPageHistory(AbstractPage page)
    {
        List history = page.getPreviousVersions();
        RemotePageHistory[] result = new RemotePageHistory[history.size()];

        for (int i = 0; i < result.length; i++)
        {
            result[i] = new RemotePageHistory((AbstractPage)history.get(i));
        }
        return result;
    }

    public static RemoteComment[] getComments(List comments)
    {
        RemoteComment[] result = new RemoteComment[comments.size()];
        for (int i = 0; i < result.length; i++)
        {
            result[i] = new RemoteComment((Comment)comments.get(i));
        }
        return result;
    }

    public static RemoteAttachment[] getAttachments(List attachments)
    {
        RemoteAttachment[] result = new RemoteAttachment[attachments.size()];
        for (int i = 0; i < result.length; i++)
        {
            result[i] = new RemoteAttachment((Attachment)attachments.get(i));
        }
        return result;
    }

}