package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.*;
import com.atlassian.confluence.rpc.soap.beans.*;

import java.util.Map;

public class ConfluenceSoapServiceImpl implements ConfluenceSoapService
{
    private ConfluenceSoapService soapServiceDelegator;

    public String login(String username, String password) throws AuthenticationFailedException, RemoteException
    {
        return soapServiceDelegator.login(username, password);
    }

    public boolean logout(String token) throws RemoteException
    {
        return soapServiceDelegator.logout(token);
    }

    public RemoteSpaceSummary[] getSpaces(String token) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getSpaces(token);
    }

    public RemoteSpace addSpace(String token, RemoteSpace space) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException
    {
        return soapServiceDelegator.addSpace(token, space);
    }

    public RemoteSpace addPersonalSpace(String token, RemoteSpace space, String username) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException
    {
        return soapServiceDelegator.addPersonalSpace(token, space, username);
    }
    
    public boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException
    {
        return soapServiceDelegator.convertToPersonalSpace(token, userName, spaceKey, newName, updateLinks);
    }

    public Boolean removeSpace(String token, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeSpace(token, spaceKey);
    }

    public RemoteSpace getSpace(String token, String spaceKey) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getSpace(token, spaceKey);
    }

    public String[] getPermissions(String token, String spaceKey) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPermissions(token, spaceKey);
    }

    public String[] getPermissionsForUser(String token, String spaceKey, String userName) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPermissionsForUser(token, spaceKey, userName);
    }

    public boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException
    {
        return soapServiceDelegator.addPermissionToSpace(token, permission, remoteEntityName, spaceKey);
    }

    public boolean addPermissionsToSpace(String token, String[] permissions, String remoteEntityName, String spaceKey) throws RemoteException
    {
        return soapServiceDelegator.addPermissionsToSpace(token, permissions, remoteEntityName, spaceKey);
    }

    public boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException
    {
        return soapServiceDelegator.removePermissionFromSpace(token, permission, remoteEntityName, spaceKey);
    }

    public boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException
    {
        return soapServiceDelegator.addAnonymousPermissionToSpace(token, permission, spaceKey);
    }

    public boolean addAnonymousPermissionsToSpace(String token, String[] permissions, String spaceKey) throws RemoteException
    {
        return soapServiceDelegator.addAnonymousPermissionsToSpace(token, permissions, spaceKey);
    }

    public boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException
    {
        return soapServiceDelegator.removeAnonymousPermissionFromSpace(token, permission, spaceKey);
    }

    public String[] getSpaceLevelPermissions(String token) throws RemoteException
    {
        return soapServiceDelegator.getSpaceLevelPermissions(token);
    }

    public RemotePageSummary[] getPages(String token, String spaceKey) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPages(token, spaceKey);
    }

    public RemotePage getPage(String token, String spaceKey, String pageTitle) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPage(token, spaceKey, pageTitle);
    }

    public RemotePage getPage(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPage(token, pageId);
    }

    public RemoteComment[] getComments(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getComments(token, pageId);
    }

    public RemoteComment getComment(String token, long commentId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getComment(token, commentId);
    }

    public RemoteComment addComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException
    {
        return soapServiceDelegator.addComment(token, comment);
    }

    public boolean removeComment(String token, long commentId) throws InvalidSessionException, NotPermittedException, RemoteException
    {
        return soapServiceDelegator.removeComment(token, commentId);
    }

    public RemotePageSummary[] getAncestors(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getAncestors(token, pageId);
    }

    public RemotePageSummary[] getChildren(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getChildren(token, pageId);
    }

    public RemotePageSummary[] getDescendents(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getDescendents(token, pageId);
    }

    public RemoteAttachment[] getAttachments(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getAttachments(token, pageId);
    }

    public RemotePageHistory[] getPageHistory(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPageHistory(token, pageId);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.renderContent(token, spaceKey, pageId, newContent);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent, Map renderParameters) throws RemoteException
    {
        return soapServiceDelegator.renderContent(token, spaceKey, pageId, newContent, renderParameters);
    }

    /* Attachments API */
    public RemoteAttachment addAttachment(String token, long contentId, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException
    {
        return soapServiceDelegator.addAttachment(token, contentId, attachment, attachmentData);
    }

    /**
     * @deprecated available for backward compatibility.
     */
    public RemoteAttachment addAttachment(String token, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException
    {
        return soapServiceDelegator.addAttachment(token, attachment, attachmentData);
    }

    public RemoteAttachment getAttachment(String token, long entityId, String fileName, int version) throws RemoteException
    {
        return soapServiceDelegator.getAttachment(token, entityId, fileName, version);
    }

    public byte[] getAttachmentData(String token, long entityId, String fileName, int version) throws RemoteException
    {
        return soapServiceDelegator.getAttachmentData(token, entityId, fileName, version);
    }

    public boolean removeAttachment(String token, long contentId, String fileName) throws RemoteException
    {
        return soapServiceDelegator.removeAttachment(token, contentId, fileName);
    }

    public boolean moveAttachment(String token, long originalContentId, String originalFileName, long newContentId, String newFileName) throws RemoteException
    {
        return soapServiceDelegator.moveAttachment(token, originalContentId, originalFileName, newContentId, newFileName);
    }

    public RemotePage storePage(String token, RemotePage page) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.storePage(token, page);
    }

    public Boolean removePage(String token, long pageId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removePage(token, pageId);
    }

    public RemoteSearchResult[] search(String token, String query, int maxResults) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.search(token, query, maxResults);
    }

    public RemoteSearchResult[] search(String token, String query, Map params, int maxResults) throws RemoteException
    {
        return soapServiceDelegator.search(token, query, params, maxResults);
    }

    /* Blog Post API */
    public RemoteBlogEntry getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException
    {
        return soapServiceDelegator.getBlogEntryByDayAndTitle(token, spaceKey, dayOfMonth, postTitle);
    }

    public RemoteBlogEntry getBlogEntry(String token, long entryId) throws RemoteException
    {
        return soapServiceDelegator.getBlogEntry(token, entryId);
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String token, String spaceKey) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getBlogEntries(token, spaceKey);
    }

    public RemoteBlogEntry storeBlogEntry(String token, RemoteBlogEntry blogEntry) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.storeBlogEntry(token, blogEntry);
    }

    /* Admin API */
    public RemoteServerInfo getServerInfo(String token) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getServerInfo(token);
    }

    public RemotePermission[] getPagePermissions(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getPagePermissions(token, pageId);
    }

    public String exportSpace(String token, String spaceKey, String exportType) throws RemoteException
    {
        return soapServiceDelegator.exportSpace(token, spaceKey, exportType);
    }

    public String exportSite(String token, boolean exportAttachments) throws RemoteException
    {
        return soapServiceDelegator.exportSite(token, exportAttachments);
    }

    public boolean flushIndexQueue(String token) throws RemoteException
    {
        return soapServiceDelegator.flushIndexQueue(token);
    }

    public boolean clearIndexQueue(String token) throws RemoteException
    {
        return soapServiceDelegator.clearIndexQueue(token); 
    }

    /* Users API */
    // Groups
    public String[] getGroups(String token) throws RemoteException
    {
        return soapServiceDelegator.getGroups(token);
    }

    public boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.hasGroup(token, groupname);
    }

    public boolean addGroup(String token, String groupname) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addGroup(token, groupname);
    }

    public boolean removeGroup(String token, String groupname, String defaultGroupName) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeGroup(token, groupname, defaultGroupName);
    }

    public boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException
    {
        return soapServiceDelegator.removeAllPermissionsForGroup(token, groupname);
    }

    public String[] getUserGroups(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getUserGroups(token, username);
    }

    public boolean addUserToGroup(String token, String username, String groupname) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addUserToGroup(token, username, groupname);
    }

    public boolean removeUserFromGroup(String token, String username, String groupname) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeUserFromGroup(token, username, groupname);
    }

    // Users
    public RemoteUser getUser(String token, String username) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getUser(token, username);
    }

    public boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.hasUser(token, username);
    }

    public void addUser(String token, RemoteUser remoteUser, String password) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        soapServiceDelegator.addUser(token, remoteUser, password);
    }

    public boolean removeUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeUser(token, username);
    }

    public boolean editUser(String token, RemoteUser remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.editUser(token, remoteUser);
    }

    public boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.deactivateUser(token, username);
    }

    public boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.reactivateUser(token, username);
    }

    public String[] getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getActiveUsers(token, viewAll);
    }

    public boolean setUserInformation(String token, RemoteUserInformation userInfo) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.setUserInformation(token, userInfo);
    }

    public RemoteUserInformation getUserInformation(String token, String username) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getUserInformation(token, username);
    }

    public boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.changeUserPassword(token, oldPass, newPass);
    }

    public boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.changeUserPassword(token, username, newPass);
    }

    public boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addProfilePicture(token, userName, fileName, mimeType, pictureData);
    }

    /* Labels API */
    public RemoteLabel[] getLabelsById(String token, long objectId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getLabelsById(token, objectId);
    }

    public RemoteLabel[] getMostPopularLabels(String token, int maxCount) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getMostPopularLabels(token, maxCount);
    }

    public RemoteLabel[] getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getMostPopularLabelsInSpace(token, spaceKey, maxCount);
    }

    public RemoteLabel[] getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getRecentlyUsedLabels(token, maxResults);
    }

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getRecentlyUsedLabelsInSpace(token, spaceKey, maxResults);
    }

    public RemoteSpace[] getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getSpacesWithLabel(token, labelName);
    }

    public RemoteLabel[] getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getRelatedLabels(token, labelName, maxResults);
    }

    public RemoteLabel[] getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getRelatedLabelsInSpace(token, labelName, spaceKey, maxResults);
    }

    public RemoteLabel[] getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException
    {
        return soapServiceDelegator.getLabelsByDetail(token, labelName, namespace, spaceKey, owner);
    }

    public RemoteSearchResult[] getLabelContentById(String token, long labelId) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getLabelContentById(token, labelId);
    }

    public RemoteSearchResult[] getLabelContentByName(String token, String labelName) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getLabelContentByName(token, labelName);
    }

    public RemoteSearchResult[] getLabelContentByObject(String token, RemoteLabel labelObject) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getLabelContentByObject(token, labelObject);
    }

    public RemoteSpace[] getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.getSpacesContainingContentWithLabel(token, labelName);
    }

    public boolean addLabelByName(String token, String labelName, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addLabelByName(token, labelName, objectId);
    }

    public boolean addLabelById(String token, long labelId, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addLabelById(token, labelId, objectId);
    }

    public boolean addLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addLabelByObject(token, labelObject, objectId);
    }

    public boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.addLabelByNameToSpace(token, labelName, spaceKey);
    }

    public boolean removeLabelByName(String token, String labelName, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeLabelByName(token, labelName, objectId);
    }

    public boolean removeLabelById(String token, long labelId, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeLabelById(token, labelId, objectId);
    }

    public boolean removeLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeLabelByObject(token, labelObject, objectId);
    }

    public boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return soapServiceDelegator.removeLabelByNameFromSpace(token, labelName, spaceKey);
    }

    // Accessor methods
    public void setSoapServiceDelegator(ConfluenceSoapService soapServiceDelegator)
    {
        this.soapServiceDelegator = soapServiceDelegator;
    }

}
