/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Feb 3, 2004
 * Time: 1:56:15 PM
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.*;
import com.atlassian.confluence.rpc.soap.services.*;
import com.atlassian.confluence.security.SpacePermission;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfluenceSoapServiceDelegator implements ConfluenceSoapService
{
    public static final List VIEW_SPACE_PERMISSION_TYPES;
    public static final List MODIFY_SPACE_PERMISSION_TYPES;
    public static final List ADMINISTRATE_PERMISSION_TYPES;
    public static final List SPACE_ADMIN_PERMISSION_TYPES;

    public static final List REMOVE_PAGE_PERMISSION_TYPES;

    public static final List EXPORT_SPACE_PERMISSION_TYPES;

    SpacesSoapService spacesService;
    PagesSoapService pagesService;
    UsersSoapService usersService;
    BlogsSoapService blogsService;
    AdminSoapService adminSoapService;
    LabelsSoapService labelsSoapService;
    AttachmentsSoapService attachmentsService;

    static
    {
        VIEW_SPACE_PERMISSION_TYPES = Arrays.asList(new String[]{SpacePermission.VIEWSPACE_PERMISSION});
        MODIFY_SPACE_PERMISSION_TYPES = Arrays.asList(new String[]{SpacePermission.CREATEEDIT_PAGE_PERMISSION});
        ADMINISTRATE_PERMISSION_TYPES = Arrays.asList(new String[]{SpacePermission.ADMINISTRATE_CONFLUENCE_PERMISSION});
        SPACE_ADMIN_PERMISSION_TYPES = Arrays.asList(new String[]{SpacePermission.ADMINISTER_SPACE_PERMISSION});

        REMOVE_PAGE_PERMISSION_TYPES = Arrays.asList(new String[]{SpacePermission.REMOVE_PAGE_PERMISSION});
        EXPORT_SPACE_PERMISSION_TYPES = Arrays.asList(new String[]{SpacePermission.EXPORT_SPACE_PERMISSION});
    }

    public void setSpacesSoapService(SpacesSoapService spacesService)
    {
        this.spacesService = spacesService;
    }

    public void setPagesSoapService(PagesSoapService pagesService)
    {
        this.pagesService = pagesService;
    }

    public void setUsersSoapService(UsersSoapService usersService)
    {
        this.usersService = usersService;
    }

    public void setBlogsSoapService(BlogsSoapService blogsService)
    {
        this.blogsService = blogsService;
    }

    public void setGlobalSoapService(AdminSoapService adminSoapService)
    {
        this.adminSoapService = adminSoapService;
    }

    public void setAdminSoapService(AdminSoapService adminSoapService)
    {
        this.adminSoapService = adminSoapService;
    }

    public void setLabelsSoapService(LabelsSoapService labelsSoapService)
    {
        this.labelsSoapService = labelsSoapService;
    }

    public void setAttachmentsSoapService(AttachmentsSoapService attachmentsService)
    {
        this.attachmentsService = attachmentsService;
    }

    public String login(String username, String password) throws RemoteException
    {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    public boolean logout(String token)
    {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    /* Spaces API */
    public RemoteSpaceSummary[] getSpaces(String token) throws RemoteException
    {
        return spacesService.getSpaces();
    }

    public RemoteSpace addSpace(String token, RemoteSpace space) throws RemoteException
    {
        return spacesService.addSpace(space);
    }

    public RemoteSpace addPersonalSpace(String token, RemoteSpace space, String username) throws RemoteException
    {
        return spacesService.addPersonalSpace(space, username);
    }

    public boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException
    {
        return spacesService.convertToPersonalSpace(userName, spaceKey, newName, updateLinks);
    }

    public Boolean removeSpace(String token, String spaceKey) throws RemoteException
    {
        return spacesService.removeSpace(spaceKey);
    }

    public RemoteSpace getSpace(String token, String spaceKey) throws RemoteException
    {
        return spacesService.getSpace(spaceKey);
    }

    public String[] getPermissions(String token, String spaceKey) throws RemoteException
    {
        return spacesService.getPermissions(spaceKey);
    }

    public String[] getPermissionsForUser(String token, String spaceKey, String userName) throws InvalidSessionException, RemoteException
    {
        return spacesService.getPermissions(spaceKey, userName);
    }

    public boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException
    {
        return spacesService.addPermissionToSpace(permission, remoteEntityName, spaceKey);
    }

    public boolean addPermissionsToSpace(String token, String[] permissions, String remoteEntityName, String spaceKey) throws RemoteException
    {
        return spacesService.addPermissionsToSpace(permissions, remoteEntityName, spaceKey);
    }

    public boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException
    {
        return spacesService.removePermissionFromSpace(permission, remoteEntityName, spaceKey);
    }

    public boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException
    {
        return spacesService.addPermissionToSpace(permission, null, spaceKey);
    }

    public boolean addAnonymousPermissionsToSpace(String token, String[] permissions, String spaceKey) throws RemoteException
    {
        return spacesService.addPermissionsToSpace(permissions, null, spaceKey);
    }

    public boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException
    {
        return spacesService.removePermissionFromSpace(permission, null, spaceKey);
    }

    public String[] getSpaceLevelPermissions(String token) throws RemoteException
    {
        return spacesService.getSpaceLevelPermissions();
    }

    /* Pages API */
    public RemotePageSummary[] getPages(String token, String spaceKey) throws RemoteException
    {
        return pagesService.getPages(spaceKey);
    }

    public RemotePage getPage(String token, String spaceKey, String pageTitle) throws InvalidSessionException, RemoteException
    {
        return pagesService.getPage(spaceKey, pageTitle);
    }

    public RemotePage getPage(String token, long pageId) throws RemoteException
    {
        return pagesService.getPage(pageId);
    }

    public RemoteComment[] getComments(String token, long pageId) throws RemoteException
    {
        return pagesService.getComments(pageId);
    }

    public RemoteComment getComment(String token, long commentId) throws InvalidSessionException, RemoteException
    {
        return pagesService.getComment(commentId);
    }

    public RemoteComment addComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException
    {
        return pagesService.addComment(comment);
    }

    public boolean removeComment(String token, long commentId) throws InvalidSessionException, NotPermittedException, RemoteException
    {
        return pagesService.removeComment(commentId);
    }

    public RemotePageSummary[] getAncestors(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return pagesService.getAncestors(pageId);
    }

    public RemotePageSummary[] getChildren(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return pagesService.getChildren(pageId);
    }

    public RemotePageSummary[] getDescendents(String token, long pageId) throws InvalidSessionException, RemoteException
    {
        return pagesService.getDescendents(pageId);
    }

    public RemoteAttachment[] getAttachments(String token, long pageId) throws RemoteException
    {
        return pagesService.getAttachments(pageId);
    }

    public RemotePageHistory[] getPageHistory(String token, long pageId) throws RemoteException
    {
        return pagesService.getPageHistory(pageId);
    }

    public RemoteSearchResult[] search(String token, String query, int maxResults) throws RemoteException
    {
        return pagesService.search(query, maxResults);
    }

    public RemoteSearchResult[] search(String token, String query, Map params, int maxResults) throws RemoteException
    {
        return pagesService.search(query, params, maxResults);
    }

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException
    {
        return blogsService.getBlogEntryByDayAndTitle(spaceKey, dayOfMonth, postTitle);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent) throws RemoteException
    {
        return pagesService.renderContent(spaceKey, pageId, newContent);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent, Map renderParameters) throws RemoteException
    {
        return pagesService.renderContent(spaceKey, pageId, newContent, renderParameters);
    }

    /* Attachments API */
    public RemoteAttachment addAttachment(String token, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException
    {
        return attachmentsService.addAttachment(attachment.getPageId(), attachment,  attachmentData);
    }

    public RemoteAttachment addAttachment(String token, long contentId, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException
    {
        return attachmentsService.addAttachment(contentId, attachment, attachmentData);
    }

    public RemoteAttachment getAttachment(String token, long contentId, String fileName, int version) throws RemoteException
    {
        return attachmentsService.getAttachment(contentId, fileName, version);
    }

    public byte[] getAttachmentData(String token, long contentId, String fileName, int version) throws RemoteException
    {
        return attachmentsService.getAttachmentData(contentId, fileName, version);
    }

    public boolean removeAttachment(String token, long contentId, String fileName) throws RemoteException
    {
        return attachmentsService.removeAttachment(contentId, fileName);
    }

    public boolean moveAttachment(String token, long originalContentId, String originalFileName, long newContentId, String newFileName) throws RemoteException
    {
        return attachmentsService.moveAttachment(originalContentId, originalFileName, newContentId, newFileName);
    }

    public Boolean removePage(String token, long pageId) throws RemoteException
    {
        return pagesService.removePage(pageId);
    }

    public RemotePage storePage(String token, RemotePage rpage) throws RemoteException
    {
        return pagesService.storePage(rpage);
    }

    public RemotePermission[] getPagePermissions(String token, long pageId) throws RemoteException
    {
        return pagesService.getPermissions(pageId);
    }

    /* Blog Post API */
    public RemoteBlogEntry getBlogEntry(String token, long entryId) throws RemoteException
    {
        return blogsService.getBlogEntry(entryId);
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String token, String spaceKey) throws RemoteException
    {
        return blogsService.getBlogEntries(spaceKey);
    }

    public RemoteBlogEntry storeBlogEntry(String token, RemoteBlogEntry remoteBlogEntry) throws RemoteException
    {
        return blogsService.storeBlogEntry(remoteBlogEntry);
    }

    /* Users API */
    // Groups
    public String[] getGroups(String token) throws RemoteException
    {
        return usersService.getGroups();
    }

    public boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException
    {
        return usersService.hasGroup(groupname);
    }

    public boolean addGroup(String token, String groupname) throws RemoteException
    {
        return usersService.addGroup(groupname);
    }

    public boolean removeGroup(String token, String groupname, String defaultGroupName) throws RemoteException
    {
        return usersService.removeGroup(groupname, defaultGroupName);
    }

    public boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException
    {
        return usersService.removeAllPermissionsForGroup(groupname);
    }

    public String[] getUserGroups(String token, String username) throws RemoteException
    {
        return usersService.getUserGroups(username);
    }

    public boolean addUserToGroup(String token, String username, String groupname) throws RemoteException
    {
        return usersService.addUserToGroup(username, groupname);
    }

    public boolean removeUserFromGroup(String token, String username, String groupname) throws RemoteException
    {
        return usersService.removeUserFromGroup(username, groupname);
    }

    // Users
    public RemoteUser getUser(String token, String username) throws RemoteException
    {
        return usersService.getUser(username);
    }

    public boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException
    {
        return usersService.hasUser(token, username);
    }

    public void addUser(String token, RemoteUser remoteUser, String password) throws RemoteException
    {
        usersService.addUser(remoteUser, password);
    }

    public boolean removeUser(String token, String username) throws RemoteException
    {
        return usersService.removeUser(username);
    }

    public boolean editUser(String token, RemoteUser remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return usersService.editUser(remoteUser);
    }

    public boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return usersService.deactivateUser(username);
    }

    public boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return usersService.reactivateUser(username);
    }

    public String[] getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException
    {
        return usersService.getActiveUsers(viewAll);
    }

    public boolean setUserInformation(String token, RemoteUserInformation userInfo) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return usersService.setUserInformation(userInfo);
    }

    public RemoteUserInformation getUserInformation(String token, String username) throws InvalidSessionException, RemoteException
    {
        return usersService.getUserInformation(username);
    }

    public boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException
    {
        return usersService.changeMyPassword(oldPass, newPass);
    }

    public boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return usersService.changeUserPassword(username, newPass);
    }
    
    public boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return usersService.addProfilePicture(userName, fileName, mimeType, pictureData);
    }

    /* Admin API */
    public RemoteServerInfo getServerInfo(String token) throws RemoteException
    {
        return adminSoapService.getServerInfo();
    }

    public String exportSpace(String token, String spaceKey, String exportType) throws RemoteException
    {
        return spacesService.exportSpace(spaceKey, exportType);
    }

    public String exportSite(String token, boolean exportAttachments) throws RemoteException
    {
        return adminSoapService.exportSite(exportAttachments);
    }

    public boolean flushIndexQueue(String token) throws RemoteException
    {
        return adminSoapService.flushIndexQueue();
    }

    public boolean clearIndexQueue(String token) throws RemoteException
    {
        return adminSoapService.clearIndexQueue();
    }

    /* Labels API */
    public RemoteLabel[] getLabelsById(String token, long objectId) throws RemoteException
    {
        return labelsSoapService.getLabelsById(objectId);
    }

    public RemoteLabel[] getMostPopularLabels(String token, int maxCount) throws RemoteException
    {
        return labelsSoapService.getMostPopularLabels(maxCount);
    }

    public RemoteLabel[] getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws RemoteException
    {
        return labelsSoapService.getMostPopularLabelsInSpace(spaceKey, maxCount);
    }

    public RemoteLabel[] getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException
    {
        return labelsSoapService.getRecentlyUsedLabels(maxResults);
    }

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException
    {
        return labelsSoapService.getRecentlyUsedLabelsInSpace(spaceKey, maxResults);
    }

    public RemoteSpace[] getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException
    {
        return labelsSoapService.getSpacesWithLabel(labelName);
    }

    public RemoteLabel[] getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException
    {
        return labelsSoapService.getRelatedLabels(labelName, maxResults);
    }

    public RemoteLabel[] getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException
    {
        return labelsSoapService.getRelatedLabelsInSpace(labelName, spaceKey, maxResults);
    }

    public RemoteLabel[] getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException
    {
        return labelsSoapService.getLabelsByDetail(labelName, namespace, spaceKey, owner);
    }

    public RemoteSearchResult[] getLabelContentById(String token, long labelId) throws RemoteException
    {
        return labelsSoapService.getLabelContentById(labelId);
    }

    public RemoteSearchResult[] getLabelContentByName(String token, String labelName) throws RemoteException
    {
        return labelsSoapService.getLabelContentByName(labelName);
    }

    public RemoteSearchResult[] getLabelContentByObject(String token, RemoteLabel labelObject) throws RemoteException
    {
        return labelsSoapService.getLabelContentByObject(labelObject);
    }

    public RemoteSpace[] getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException
    {
        return labelsSoapService.getSpacesContainingContentWithLabel(labelName);
    }

    public boolean addLabelByName(String token, String labelName, long objectId) throws NotPermittedException, RemoteException
    {
        return labelsSoapService.addLabelByName(labelName, objectId);
    }

    public boolean addLabelById(String token, long labelId, long objectId) throws NotPermittedException, RemoteException
    {
        return labelsSoapService.addLabelById(labelId, objectId);
    }

    public boolean addLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, RemoteException
    {
        return labelsSoapService.addLabelByObject(labelObject, objectId);
    }

    public boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return labelsSoapService.addLabelByNameToSpace(labelName, spaceKey);
    }

    public boolean removeLabelByName(String token, String labelName, long objectId) throws NotPermittedException, RemoteException
    {
        return labelsSoapService.removeLabelByName(labelName, objectId);
    }

    public boolean removeLabelById(String token, long labelId, long objectId) throws NotPermittedException, RemoteException
    {
        return labelsSoapService.removeLabelById(labelId, objectId);
    }

    public boolean removeLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, RemoteException
    {
        return labelsSoapService.removeLabelByObject(labelObject, objectId);
    }

    public boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException
    {
        return labelsSoapService.removeLabelByNameFromSpace(labelName, spaceKey);
    }

}