/*
 * Created by IntelliJ IDEA.
 * User: Mike
 * Date: Jul 15, 2004
 * Time: 5:11:05 PM
 */
package com.atlassian.confluence.extra.calendar;

import com.atlassian.confluence.extra.calendar.model.CalendarModel;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.radeox.macros.include.AbstractHttpRetrievalMacro;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.gregory.ICalendar;
import com.atlassian.gregory.ICalendarParser;
import com.opensymphony.webwork.ServletActionContext;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Category;
import org.radeox.macro.parameter.MacroParameter;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;

public class CalendarMacro extends AbstractHttpRetrievalMacro
{
    private static Category log = Category.getInstance(CalendarMacro.class);
    private static final String MONTH_VIEW = "month";
    private static final String WEEK_VIEW = "week";
    private static final String DAY_VIEW = "day";

    public String getName()
    {
        return "calendar";
    }

    protected String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException
    {
        // retrieve the first parameter passed, in our case the name of the task list.
        String url = macroParameter.get(0);

        HttpMethod method = retrieveRemoteUrl(url);

        ICalendar cal = ICalendarParser.parse(method.getResponseBodyAsStream());

        // now create a simple velocity context and render a template for the output
        Map contextMap = MacroUtils.defaultVelocityContext();

        final CalendarModel model = setupModel(cal);

        contextMap.put("model", model);
        contextMap.put("calendar", cal);
        contextMap.put("content", MacroUtils.getContentEntityObject(macroParameter));

        String view = setupView();

        try
        {
            if (MONTH_VIEW.equals(view))
                return VelocityUtils.getRenderedTemplate("templates/extra/calendar/calendar-month.vm", contextMap);
            else if (WEEK_VIEW.equals(view))
                return VelocityUtils.getRenderedTemplate("templates/extra/calendar/calendar-week.vm", contextMap);
            else if (DAY_VIEW.equals(view))
                return VelocityUtils.getRenderedTemplate("templates/extra/calendar/calendar-day.vm", contextMap);
            else
                return errorContent("Invalid view (" + view + ") specified?");
        }
        catch (Exception e)
        {
            log.error("Error while trying to display TaskList!", e);
            throw new IOException(e.getMessage());
        }
    }

    private String setupView()
    {
        final HttpServletRequest request = ServletActionContext.getRequest();

        if (request != null)
        {
            if (request.getParameter("calendar.view") != null)
                return request.getParameter("calendar.view");
        }

        return MONTH_VIEW;
    }

    private CalendarModel setupModel(ICalendar cal)
    {
        final CalendarModel model = new CalendarModel(cal);

        final HttpServletRequest request = ServletActionContext.getRequest();

        if (request != null)
        {
            if (request.getParameter("calendar.year") != null)
                model.setYear(Integer.parseInt(request.getParameter("calendar.year")));

            if (request.getParameter("calendar.month") != null)
                model.setMonth(Integer.parseInt(request.getParameter("calendar.month")));

            if (request.getParameter("calendar.day") != null)
                model.setDay(Integer.parseInt(request.getParameter("calendar.day")));
        }

        model.init();

        return model;
    }

}