package com.atlassian.confluence.extra.auditer;

import com.atlassian.confluence.event.EventListener;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.util.GeneralUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.Appender;

import java.util.Properties;
import java.util.Enumeration;

public class AuditListener implements EventListener
{
    private static Logger log = Logger.getLogger(AuditListener.class);
    private static final Class[] handledClasses = new Class[]{ConfluenceEvent.class};
    boolean initialized;

    private void initializeLogger()
    {
        Properties auditConfigProps = GeneralUtil.getProperties("audit.log4j.properties", getClass());

        try
        {
            PropertyConfigurator.configure(auditConfigProps);
        }
        catch (NullPointerException e)
        {
            log.error("Could not locate audit.org4j.properties file on classpath");    
        }

        initialized = true;
    }

    public void handleEvent(ConfluenceEvent event)
    {
        if (!initialized)
           initializeLogger();

        log.info(event);
    }

    /**
     * Returns an empty array, thereby handling every ConfluenceEvent
     * @return
     */
    public Class[] getHandledEventClasses()
    {
        return handledClasses;
    }
}
