package com.atlassian.confluence.extra.amazon;

import org.jdom.Element;
import org.jdom.Namespace;

public class Product
{
    private Element item;
    private Namespace ns;

    public class Image
    {
        private Element image;

        public Image(Element image)
        {
            this.image = image;
        }

        public String getUrl()
        {
            return image.getChildText("URL", ns);
        }

        public String getWidth()
        {
            return image.getChildText("Width", ns);
        }

        public String getHeight()
        {
            return image.getChildText("Height", ns);
        }
    }

    public class Review
    {
        private Element review;

        public Review(Element review)
        {
            this.review = review;
        }

        public String getText()
        {
            return review.getChildText("Content", ns);
        }

        public String getBy()
        {
            return review.getChildText("Source", ns);
        }
    }

    public Product(Element item)
    {
        this.item = item;
        this.ns = item.getNamespace();
    }

    public String getTitle()
    {
        return item.getChild("ItemAttributes", ns).getChildText("Title", ns);
    }

    public String getBy()
    {
        Element itemAttributes = item.getChild("ItemAttributes", ns);

        if (itemAttributes.getChild("Author", ns) != null)
            return itemAttributes.getChildText("Author", ns);

        if (itemAttributes.getChild("Artist", ns) != null)
            return itemAttributes.getChildText("Artist", ns);

        if (itemAttributes.getChild("Director", ns) != null)
            return itemAttributes.getChildText("Director", ns);

        return null;
    }

    public String getPrice()
    {
        Element listPrice = item.getChild("ItemAttributes", ns).getChild("ListPrice", ns);
        return listPrice.getChildText("FormattedPrice", ns) + "(" + listPrice.getChildText("CurrencyCode", ns) + ")";
    }

    public Image getSmallImage()
    {
        return new Image(item.getChild("SmallImage", ns));
    }

    public Image getMediumImage()
    {
        return new Image(item.getChild("MediumImage", ns));
    }

    public Image getLargeImage()
    {
        return new Image(item.getChild("LargeImage", ns));
    }

    public Review getFirstReview()
    {
        return new Review(item.getChild("EditorialReviews", ns).getChild("EditorialReview", ns));
    }

}
