<%@ page import="javax.naming.InitialContext,
                 javax.sql.DataSource,
                 javax.naming.Context,
                 javax.naming.NamingException,
                 java.sql.*,
                 org.springframework.orm.hibernate.SessionFactoryUtils,
                 net.sf.hibernate.SessionFactory,
                 bucket.container.ContainerManager,
                 org.hsqldb.Row,
                 com.atlassian.user.User,
                 com.atlassian.user.UserManager,
                 java.util.*,
                 com.atlassian.user.util.migration.OSUEntityMigrator,
                 com.atlassian.user.GroupManager,
                 com.atlassian.user.properties.PropertySetFactory,
                 com.opensymphony.user.provider.ProfileProvider,
                 com.opensymphony.user.provider.AccessProvider,
                 net.sf.hibernate.Session,
                 com.atlassian.user.impl.osuser.OSUAccessor,
                 com.atlassian.user.util.migration.EntityMigrator" %>
<%@ page import="com.atlassian.user.EntityException"%>
<%@ page import="com.atlassian.user.impl.DuplicateEntityException"%>

<%@ page contentType="text/html; charset=UTF-8" %>

<!--
If you want to use this utility to double check your database settings *before* setting
up Confluence you need to set it up within a separate web application in your app. server. -->
<html>
<head>
    <title>Atlassian User Transfer Utility</title>

</head>
<!-- A JSP which will transport current OSUser users and groups (and related property properties) to
a corresponding form in the primary Atlassian User repository.
-->

<body>

This will migrate your existing users.


<p>
    <a href="<%=request.getContextPath()%>/admin/osuser2atluser.jsp?migrate=start">Begin migration</a>.
</p>
<%
    EntityMigrator migrator = null;
    String migrate = request.getParameter("migrate");
    try
    {
        migrator = (EntityMigrator) ContainerManager.getComponent("osuserMigrationBean");
    }
    catch (Exception e)
    {
    }

    if (migrator != null)
    {
        if (migrate != null)
        {
            SessionFactory sessionFactory = (SessionFactory) ContainerManager.getComponent("sessionFactory");
            Session hibernateSession = SessionFactoryUtils.getSession(sessionFactory, true);
            Connection conn = hibernateSession.connection();

            out.print("Migrating users ... ");
            try
            {
                migrator.migrateUsers(conn);
                out.print("Users migrated successfully! <br/>");
                out.print("Migrating propertyset data ... ");
                migrator.migratePropertySetItems();
                out.print("Propertyset data migrated successfully! <br/>");
                out.print("Migrating groups ... ");
                migrator.migrateGroups();
                out.print("Groups migrated successfully! <br/>");
            }
            catch (DuplicateEntityException dee)
            {
                out.println("<font color='red'><b>ERROR</b><br/><blockquote>" + dee.getMessage() + "</font><br/>");
                out.println("If you are upgrading from Confluence 2.1.x and have already performed this migration previously - <i>you do not need to perform this again</i>. You only need to move your settings over as outlined in <a href='http://confluence.atlassian.com/x/tp8C'>this document.</a><br/>");
                out.println("Otherwise, please ensure that in your: <pre>confluence/WEB-INF/classes/atlassian-user.xml</pre> file, that the hibernateRepository is first and the osuserRepository is second.<br/></blockquote>");
            }
        }
    }
    else
    {
        out.println("<font color='red'>The configuration for the osuserMigrationBean is missing.</font>");
    }
    

%>

</body>