<%@ page import="org.apache.lucene.index.IndexReader,
				 java.io.IOException,
				 org.apache.lucene.document.Document,
				 java.util.Enumeration,
				 org.apache.lucene.document.Field,
                 java.util.Iterator,
                 java.net.URLEncoder,
                 org.apache.lucene.index.IndexWriter,
                 bucket.search.lucene.analyzer.DefaultLuceneAnalyzerFactory,
                 com.atlassian.confluence.util.GeneralUtil" %>

<%@ page contentType="text/html; charset=UTF-8" %>                 

<%
    String indexDir = null;

	if (request.getParameter("lucene.index.dir") != null)
	{
		session.setAttribute("lucene.index.dir", request.getParameter("lucene.index.dir"));
	}

    if (session.getAttribute("lucene.index.dir") != null)
    {
        indexDir = (String)session.getAttribute("lucene.index.dir");
    }
%>

<html>

	<head>

		<title>Index Browser</title>

	</head>

	<body>

	<p>

	<form action="indexbrowser.jsp">
		Which index would you like to browse?

        <input name="lucene.index.dir" value="<%= indexDir != null ? indexDir : "" %>">

		<input type="submit" value="Refresh">
	</form>

	<hr>

	<%
        IndexReader reader = null;

        if (indexDir != null)
        {

			try
			{
                // IndexWriter writer = new IndexWriter(indexDir, new DefaultLuceneAnalyzerFactory().createAnalyzer(), false);
                // writer.optimize();
                // writer.close();

				reader = IndexReader.open(indexDir);
			}
			catch (IOException e)
			{
				out.println("<b>Error</b>: Could not open index: " + e);
			}
		}
	%>

	<% if (reader != null) {
        int numDocs = reader.numDocs();
    %>

	<b>Index Location</b>: <%=  indexDir %><br/>
	<b>Number of Documents</b>: <%= numDocs %><br/>


	<ol>
	<%
		for (int i = 0; i < numDocs; i++) {
			try {
                Document doc = reader.document(i);
	%>
		<li><b><a href="viewdocument.jsp?doc=<%= i %>"><%= doc.get("handle") + " : " + GeneralUtil.escapeXml(doc.get("title")) %></a></b></li>
	<%
		    } catch (Exception e)
            {
    %>
        <li><b>Error: <%= e %></b></li>
    <%
            }
        }
	%>
	</ol>

	<% reader.close(); %>
	<% } %>


</body>

</html>

