<%@ page import="net.sf.ehcache.Cache,
                 net.sf.ehcache.CacheManager,
                 java.net.URLEncoder"%>

<html>
    <head>
        <title>CacheManager Status</title>
    </head>

    <body>

    <style type="text/css">
        th {font-size: 10px;}
    </style>

<% CacheManager mgr = CacheManager.getInstance(); %>

CacheManager status: <%= printStatus(mgr.getStatus()) %><br/>

<div align="center">
<table border="1" cellspacing="2px">
    <tr>
        <th>Cache</th>
        <th>Status</th>
        <th>Size</th>
        <th>Ratio</th>
        <th>Access</th>
        <th>Hit</th>
        <th>Miss <br/>(Not Found)</th>
        <th>Miss <br/>(Expired)</th>
        <th>Size (MB)</th>
    </tr>
<%
    long totalInMemorySize = 0;
    final int MEGABYTE = 1024*1024;

    for (int i = 0; i < mgr.getCacheNames().length; i++)
    {
        String cacheName = mgr.getCacheNames()[i];
        Cache cache = mgr.getCache(cacheName);

        int cacheAccesses = cache.getMissCountExpired() + cache.getMissCountNotFound() + cache.getHitCount();
        long inMemorySize = cache.calculateInMemorySize();
%>
    <tr>
        <td class="smallfont"><a href="cacheitems.jsp?cache=<%= URLEncoder.encode(cache.getName()) %>"><%= cache.getName() %></a></td>
        <td class="smallfont"><%= printStatus(cache.getStatus()) %></td>
        <td class="smallfont"><%= cache.getSize() %></td>
        <td class="smallfont"><%= (cacheAccesses > 0 ? (int)(((float)cache.getHitCount() / (float)cacheAccesses) * 100) : 0) %>%</td>
        <td class="smallfont"><%= cacheAccesses %></td>
        <td class="smallfont"><%= cache.getHitCount() %></td>
        <td class="smallfont"><%= cache.getMissCountNotFound() %></td>
        <td class="smallfont"><%= cache.getMissCountExpired() %></td>
        <td class="smallfont"><%= inMemorySize/MEGABYTE %> MB</td>
    </tr>
<%
        totalInMemorySize += inMemorySize;
    }
%>
</table>
</div>
<b>Total Size of cache Memory: </b> <%= totalInMemorySize/MEGABYTE %> MB
</body>
</html>

<%!
    private String printStatus(int status)
    {
        switch (status)
        {
            case Cache.STATUS_ALIVE:
            {
                return "<font color=006600>Alive</font>";
            }
            case Cache.STATUS_DISPOSED:
            {
                return "<font color=660000>Disposed</font>";
            }
            case Cache.STATUS_UNINITIALISED:
            {
                return "Unitialized";
            }
        }

        return "Unknown";
    }
%>
