<%@ page import="net.sf.ehcache.CacheManager,
                 net.sf.ehcache.Cache,
                 java.net.URLEncoder,
                 java.io.Serializable,
                 net.sf.ehcache.Element"%>
<%@ page import="java.util.*"%>

<%
    CacheManager mgr = CacheManager.getInstance();
    String cacheName = request.getParameter("cache");
    Cache cache = mgr.getCache(cacheName);
%>


<html>
    <head>
        <title>Cache Status : <%= cacheName %></title>
    </head>

    <body>

Cache status: <%= printStatus(cache.getStatus()) %><br/>
System time: <%= new Date() %><br/>
<a href="caches.jsp">View all caches</a><br/>

<div align="center">
<table class="grid" border="1" cellpadding="10">
    <tr>
        <th>Index</th>
        <th>Key</th>
        <th>Value</th>
        <th>Vers</th>
        <th>Hit</th>
        <th>Created</th>
        <th>Last Accessed</th>
    </tr>
<%
    List cacheItems = new ArrayList();

    for (Iterator iterator = cache.getKeys().iterator(); iterator.hasNext();)
    {
        Serializable key = (Serializable) iterator.next();
        cacheItems.add(cache.get(key));
    }

    Collections.sort(cacheItems, new Comparator()
    {
        public int compare(Object o1, Object o2)
        {
            return (int) (((Element)o2).getHitCount() - ((Element)o1).getHitCount());
        }
    }
    );

    for (int i = 0; i < cacheItems.size(); i++)
    {
        Element element = (Element) cacheItems.get(i);
%>
    <tr>
        <td class="smallfont"><%= i %></td>
        <td class="smallfont"><%= element.getKey() %></td>
        <td class="smallfont"><%= element.getValue() %></td>
        <td class="smallfont"><%= element.getVersion() %></td>
        <td class="smallfont"><%= element.getHitCount() %></td>
        <td class="smallfont"><%= new Date(element.getCreationTime()) %></td>
        <td class="smallfont"><%= new Date(element.getLastAccessTime()) %></td>
    </tr>
<%
    }
%>
</table>
</div>

</body>
</html>

<%!
    private String printStatus(int status)
    {
        switch (status)
        {
            case Cache.STATUS_ALIVE:
            {
                return "<font color=006600>Alive</font>";
            }
            case Cache.STATUS_DISPOSED:
            {
                return "<font color=660000>Disposed</font>";
            }
            case Cache.STATUS_UNINITIALISED:
            {
                return "Unitialized";
            }
        }

        return "Unknown";
    }
%>
