/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.wysiwyg;

import com.atlassian.core.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TinyMCEServlet
extends HttpServlet {
    private static final String MCE_BASE = "/includes/js/tiny_mce/";
    private static Map mceConfigurationCache = new HashMap();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String theme = request.getParameter("theme");
        String language = request.getParameter("language");
        String plugins = request.getParameter("plugins");
        String suffix = "_src";
        if (suffix == null) {
            suffix = "";
        }
        if (theme == null) {
            theme = "";
        }
        ServletContext context = request.getSession().getServletContext();
        response.setContentType("text/javascript");
        response.setHeader("Cache-Control", "must-revalidate");
        response.setDateHeader("Expires", new Date().getTime() + 3600000L);
        String encoding = response.getCharacterEncoding();
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("theme", theme);
        key.put("language", language);
        key.put("plugins", plugins);
        key.put("suffix", suffix);
        key.put("encoding", encoding);
        byte[] data = (byte[])mceConfigurationCache.get(key);
        if (data == null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (!theme.equals("")) {
                if (language == null) {
                    throw new ServletException("no language specified.");
                }
                this.writeFile(context, "/includes/js/tiny_mce/tiny_mce" + suffix + ".js", os, false);
                this.writeString(os, encoding, "TinyMCE.prototype.loadScript = function() {};\n");
                this.writeString(os, encoding, "tinyMCE.init(TinyMCECompressed_settings);\n");
                this.writeFile(context, "/includes/js/tiny_mce/themes/" + theme + "/editor_template" + suffix + ".js", os, false);
                this.writeFile(context, "/includes/js/tiny_mce/themes/" + theme + "/langs/" + language + ".js", os, false);
                this.writeFile(context, "/includes/js/tiny_mce/langs/" + language + ".js", os, false);
                String[] pluginsArray = plugins.split(",");
                for (int i = 0; i < pluginsArray.length; ++i) {
                    this.writeFile(context, "/includes/js/tiny_mce/plugins/" + pluginsArray[i] + "/editor_plugin" + suffix + ".js", os, true);
                    this.writeFile(context, "/includes/js/tiny_mce/plugins/" + pluginsArray[i] + "/langs/" + language + ".js", os, true);
                }
            } else {
                this.writeString(os, encoding, "var TinyMCECompressed_settings = null;\n\nfunction TinyMCECompressed() {\n}\n\nTinyMCECompressed.prototype.init = function(settings) {\n\tvar elements = document.getElementsByTagName('script');\n\tvar scriptURL = \"\";\n\n\tfor (var i=0; i<elements.length; i++) {\n\t\tif (elements[i].src && elements[i].src.indexOf(\"tiny_mce/zip\") != -1) {\n\t\t\tscriptURL = elements[i].src;\n\t\t\tbreak;\n\t\t}\n\t}\n\n\tsettings[\"theme\"] = typeof(settings[\"theme\"]) != \"undefined\" ? settings[\"theme\"] : \"default\";\n\tsettings[\"plugins\"] = typeof(settings[\"plugins\"]) != \"undefined\" ? settings[\"plugins\"] : \"\";\n\tsettings[\"language\"] = typeof(settings[\"language\"]) != \"undefined\" ? settings[\"language\"] : \"en\";\n\tsettings[\"button_tile_map\"] = typeof(settings[\"button_tile_map\"]) != \"undefined\" ? settings[\"button_tile_map\"] : true;\n\n\tscriptURL += \"?theme=\" + escape(settings[\"theme\"]) + \"&language=\" + escape(settings[\"language\"]) + \"&plugins=\" + escape(settings[\"plugins\"]);\n\tdocument.write('<sc'+'ript language=\"javascript\" type=\"text/javascript\" src=\"' + scriptURL + '\"></script>');\n\n\tTinyMCECompressed_settings = settings;\n}\n\nvar tinyMCE = new TinyMCECompressed();");
            }
            os.close();
            data = os.toByteArray();
            if (System.getProperty("confluence.disable.caches", "false").equals("false")) {
                mceConfigurationCache.put(key, data);
            }
        }
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    private void writeString(OutputStream os, String encoding, String s) throws IOException {
        os.write(s.getBytes(encoding));
    }

    private void writeFile(ServletContext context, String path, OutputStream os, boolean optional) throws IOException, ServletException {
        InputStream is = context.getResourceAsStream(path);
        if (is != null) {
            FileUtils.copy((InputStream)is, (OutputStream)os);
        } else if (!optional) {
            throw new ServletException("resource " + path + " not found.");
        }
    }
}

