/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.wysiwyg;

import com.atlassian.renderer.wysiwyg.DefaultTidyMessageListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessageListener;

public abstract class JTidyUtil {
    private Tidy tidy = new Tidy();
    private ByteArrayOutputStream out;
    private Document document;
    private DefaultTidyMessageListener listener;

    public ByteArrayOutputStream getOut() {
        return this.out;
    }

    public Document getDocument() {
        return this.document;
    }

    public DefaultTidyMessageListener getListener() {
        return this.listener;
    }

    public JTidyUtil(String xhtml) throws UnsupportedEncodingException {
        this(new ByteArrayInputStream(xhtml.getBytes("UTF-8")));
    }

    public JTidyUtil(InputStream in) {
        this.tidy.setXHTML(true);
        this.tidy.setMakeClean(false);
        this.tidy.setInputEncoding("UTF-8");
        this.tidy.setOutputEncoding("UTF-8");
        this.tidy.setShowWarnings(false);
        this.tidy.setQuiet(true);
        this.tidy.setPrintBodyOnly(true);
        this.tidy.setJoinClasses(false);
        this.tidy.setDropFontTags(false);
        this.tidy.setReplaceColor(false);
        this.listener = new DefaultTidyMessageListener();
        this.tidy.setMessageListener((TidyMessageListener)this.listener);
        this.out = new ByteArrayOutputStream();
        this.init(this.tidy);
        this.document = this.tidy.parseDOM(in, (OutputStream)this.out);
    }

    protected abstract void init(Tidy var1);

    public Node findTag(String name) {
        return this.findTag(name, this.document);
    }

    private Node findTag(String name, Node node) {
        if (node.getNodeName().toLowerCase().equals(name.toLowerCase())) {
            return node;
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = this.findTag(name, node.getChildNodes().item(i));
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public String getText(Node node) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString();
    }
}

