/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.basic;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.V2SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.basic.AbstractPanelMacro;
import java.util.Map;

public class NoformatMacro
extends AbstractPanelMacro {
    public NoformatMacro() {
    }

    public NoformatMacro(V2SubRenderer subRenderer) {
        this.setSubRenderer(subRenderer);
    }

    protected String getPanelCSSClass() {
        return "preformatted";
    }

    protected String getPanelHeaderCSSClass() {
        return "preformattedHeader";
    }

    protected String getPanelContentCSSClass() {
        return "preformattedContent";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if ("true".equals(parameters.get("nopanel"))) {
            return this.getBodyContent(parameters, body, renderContext);
        }
        return super.execute(parameters, body, renderContext);
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.allow(128L);
    }

    protected String getBodyContent(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (body.startsWith("\n")) {
            body = body.substring(1);
        }
        if (body.startsWith("\r\n")) {
            body = body.substring(2);
        }
        return super.getBodyContent(parameters, "<pre>" + body + "</pre>", renderContext);
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return false;
    }
}

