/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.basic;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public abstract class AbstractPanelMacro
extends BaseMacro {
    private SubRenderer subRenderer;

    protected abstract String getPanelCSSClass();

    protected abstract String getPanelHeaderCSSClass();

    protected abstract String getPanelContentCSSClass();

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public boolean hasBody() {
        return true;
    }

    protected String getBodyContent(Map parameters, String body, RenderContext renderContext) throws MacroException {
        return body;
    }

    protected String getTitle(Map parameters, String body, RenderContext renderContext) {
        return (String)parameters.get("title");
    }

    public boolean isInline() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        StringBuffer buffer = new StringBuffer(body.length() + 100);
        String title = this.subRenderer.render(this.getTitle(parameters, body, renderContext), renderContext, renderContext.getRenderMode().and(RenderMode.INLINE));
        body = this.getBodyContent(parameters, body, renderContext);
        String borderStyle = (String)parameters.get("borderStyle");
        String borderColor = (String)parameters.get("borderColor");
        Integer borderWidth = null;
        String borderWidthString = (String)parameters.get("borderWidth");
        if (borderWidthString != null) {
            if (borderWidthString.indexOf("px") != -1) {
                borderWidthString = borderWidthString.replaceAll("px", "");
            }
            borderWidth = new Integer(borderWidthString);
        }
        String backgroundColor = (String)parameters.get("bgColor");
        String titleBackgroundColor = (String)parameters.get("titleBGColor");
        if (!TextUtils.stringSet((String)titleBackgroundColor) && TextUtils.stringSet((String)backgroundColor)) {
            titleBackgroundColor = backgroundColor;
        }
        buffer.append("<div class=\"" + this.getPanelCSSClass() + "\"");
        if (TextUtils.stringSet((String)borderStyle)) {
            buffer.append(" style=\"border-style: " + borderStyle + "; ");
            if (borderWidth != null && borderWidth >= 1) {
                buffer.append("border-width: " + borderWidth + "px; ");
            }
            if (TextUtils.stringSet((String)borderColor)) {
                buffer.append("border-color: " + borderColor + "; ");
            }
            buffer.append("\"");
        }
        buffer.append(">");
        if (TextUtils.stringSet((String)title)) {
            this.writeHeader(renderContext, buffer, title, borderStyle, borderColor, borderWidth, titleBackgroundColor);
        }
        if (TextUtils.stringSet((String)body)) {
            this.writeContent(buffer, parameters, body, backgroundColor);
        }
        buffer.append("</div>");
        return buffer.toString();
    }

    protected void writeHeader(RenderContext renderContext, StringBuffer buffer, String title, String borderStyle, String borderColor, Integer borderWidth, String titleBackgroundColor) {
        buffer.append("<div class=\"" + this.getPanelHeaderCSSClass() + "\"" + (renderContext.isRenderingForWysiwyg() ? " wysiwyg=\"ignore\" " : ""));
        if (TextUtils.stringSet((String)borderStyle) || TextUtils.stringSet((String)titleBackgroundColor)) {
            buffer.append(" style=\"");
            if (TextUtils.stringSet((String)borderStyle)) {
                buffer.append("border-bottom-style: " + borderStyle + "; ");
                if (borderWidth != null && borderWidth >= 1) {
                    buffer.append("border-bottom-width: " + borderWidth + "; ");
                }
                if (TextUtils.stringSet((String)borderColor)) {
                    buffer.append("border-bottom-color: " + borderColor + "; ");
                }
            }
            if (TextUtils.stringSet((String)titleBackgroundColor)) {
                buffer.append("background-color: " + titleBackgroundColor + "; ");
            }
            buffer.append("\"");
        }
        buffer.append("><b>");
        buffer.append(title);
        buffer.append("</b></div>");
    }

    protected void writeContent(StringBuffer buffer, Map parameters, String content, String backgroundColor) {
        buffer.append("<div class=\"" + this.getPanelContentCSSClass() + "\"");
        if (TextUtils.stringSet((String)backgroundColor)) {
            buffer.append(" style=\"background-color: " + backgroundColor + "; \"");
        }
        buffer.append(">\n");
        buffer.append(content.trim());
        buffer.append("\n</div>");
    }

    protected SubRenderer getSubRenderer() {
        return this.subRenderer;
    }
}

