/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.macro.RadeoxCompatibilityMacro;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.AbstractRendererComponent;
import com.atlassian.renderer.v2.components.HtmlEscapeRendererComponent;
import com.atlassian.renderer.v2.components.MacroTag;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.atlassian.renderer.v2.macro.ResourceAwareMacroDecorator;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;

public class MacroRendererComponent
extends AbstractRendererComponent {
    private static Category log = Category.getInstance((Class)(class$com$atlassian$renderer$v2$components$MacroRendererComponent == null ? (class$com$atlassian$renderer$v2$components$MacroRendererComponent = MacroRendererComponent.class$("com.atlassian.renderer.v2.components.MacroRendererComponent")) : class$com$atlassian$renderer$v2$components$MacroRendererComponent));
    private final MacroManager macroManager;
    private final SubRenderer subRenderer;
    static /* synthetic */ Class class$com$atlassian$renderer$v2$components$MacroRendererComponent;

    public MacroRendererComponent(MacroManager macroManager, SubRenderer subRenderer) {
        this.macroManager = macroManager;
        this.subRenderer = subRenderer;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderMacros();
    }

    public String render(String wiki, RenderContext context) {
        if (wiki.indexOf("{") == -1) {
            return wiki;
        }
        int lastStart = 0;
        boolean inEscape = false;
        StringBuffer out = new StringBuffer(wiki.length());
        for (int i = 0; i < wiki.length(); ++i) {
            char c = wiki.charAt(i);
            if (!inEscape) {
                switch (c) {
                    case '\\': {
                        inEscape = true;
                        break;
                    }
                    case '{': {
                        if (wiki.length() > i + 1 && "{*?^_-+~".indexOf(wiki.charAt(i + 1)) != -1) {
                            ++i;
                            break;
                        }
                        out.append(wiki.substring(lastStart, i));
                        lastStart = i + 1;
                        i = this.handlePotentialMacro(wiki, i, out, context);
                        lastStart = i + 1;
                    }
                }
                continue;
            }
            inEscape = false;
        }
        if (lastStart < wiki.length()) {
            out.append(wiki.substring(lastStart));
        }
        return out.toString();
    }

    private int handlePotentialMacro(String wiki, int i, StringBuffer out, RenderContext context) {
        MacroTag startTag = MacroTag.makeMacroTag(wiki, i);
        if (startTag != null) {
            Macro macro = this.getMacroByName(startTag.command);
            int endTagOffset = 0;
            if (macro == null || macro.hasBody()) {
                endTagOffset = this.findEndTagOffset(wiki, startTag);
            }
            if (endTagOffset > 0) {
                this.makeMacro(out, wiki, startTag, endTagOffset, context);
                i = endTagOffset + startTag.command.length() + 1;
            } else {
                this.makeMacro(out, startTag, context);
                i = startTag.endIndex;
            }
        } else {
            out.append('{');
        }
        return i;
    }

    private void makeMacro(StringBuffer buffer, MacroTag startTag, RenderContext context) {
        this.makeMacro(buffer, startTag, "", context, false);
    }

    private void makeMacro(StringBuffer buffer, String wiki, MacroTag startTag, int endTagOffset, RenderContext context) {
        String body = wiki.substring(startTag.endIndex + 1, endTagOffset);
        boolean hasEndTag = endTagOffset > 0;
        this.makeMacro(buffer, startTag, body, context, hasEndTag);
    }

    private void makeMacro(StringBuffer buffer, MacroTag startTag, String body, RenderContext context, boolean hasEndTag) {
        Macro macro = this.getMacroByName(startTag.command);
        Map params = this.makeParams(startTag.argString);
        if (context.isRenderingForWysiwyg()) {
            String tag = this.getWysiwygMacroElement(macro);
            if (macro == null || macro.getBodyRenderMode() != null && macro.getBodyRenderMode().equals(RenderMode.NO_RENDER) || !macro.hasBody()) {
                StringBuffer sb = new StringBuffer();
                if (tag != null) {
                    sb.append("<" + tag + " class=\"macro\">");
                    sb.append(startTag.originalText + body.replaceAll("\n", "<br/>"));
                    if (body.length() > 0 || hasEndTag) {
                        sb.append("{" + startTag.command + "}");
                    }
                    sb.append("</" + tag + ">");
                    buffer.append(context.getRenderedContentStore().addBlock(sb.toString()));
                } else {
                    this.processMacro(startTag.command, macro, body, params, context, buffer);
                }
            } else if (!macro.suppressMacroRenderingDuringWysiwyg()) {
                if (tag != null) {
                    buffer.append(context.getRenderedContentStore().addBlock("<" + tag + " class=\"macro\" macrotext=\"" + startTag.originalText + "\" command=\"" + startTag.command + "\">"));
                }
                this.processMacro(startTag.command, macro, body, params, context, buffer);
                if (tag != null) {
                    buffer.append(context.getRenderedContentStore().addBlock("</" + tag + ">"));
                }
            } else {
                buffer.append(context.getRenderedContentStore().addBlock("<div class=\"wikisrc\">" + (macro.isInline() ? "" : "\n") + startTag.originalText + "</div>"));
                if (!((macro instanceof RadeoxCompatibilityMacro || macro instanceof ResourceAwareMacroDecorator && ((ResourceAwareMacroDecorator)macro).getMacro() instanceof RadeoxCompatibilityMacro) && body.equals(""))) {
                    RenderMode renderMode = RenderMode.suppress(256L);
                    if (macro.getBodyRenderMode() != null) {
                        renderMode = macro.getBodyRenderMode().and(renderMode);
                    }
                    buffer.append(context.addRenderedContent(this.subRenderer.render(body, context, renderMode)));
                    buffer.append(context.getRenderedContentStore().addBlock("<div class=\"wikisrc\">" + (macro.isInline() ? "" : "\n") + "{" + startTag.command + "}" + "</div>"));
                }
            }
            if (tag != null && tag.equals("div")) {
                buffer.append(context.getRenderedContentStore().addBlock("<p>&#8201;</p>"));
            } else if (!macro.suppressSurroundingTagDuringWysiwygRendering()) {
                buffer.append(context.getRenderedContentStore().addBlock("&#8201;"));
            }
        } else if (macro != null) {
            this.processMacro(startTag.command, macro, body, params, context, buffer);
        } else if (!context.getRenderMode().renderMacroErrorMessages()) {
            HtmlEscapeRendererComponent htmlEscapeRendererComponent = new HtmlEscapeRendererComponent();
            StringBuffer errorBuffer = new StringBuffer();
            errorBuffer.append(htmlEscapeRendererComponent.render(startTag.originalText, context));
            if (body != null && !"".equals(body.trim())) {
                errorBuffer.append(this.subRenderer.render(body, context, context.getRenderMode().and(RenderMode.suppress(257L))));
                errorBuffer.append("{" + htmlEscapeRendererComponent.render(startTag.command, context) + "}");
            }
            buffer.append(context.getRenderedContentStore().addBlock(errorBuffer.toString()));
        } else {
            buffer.append(this.makeMacroError(context, "Unknown macro: {" + startTag.command + "}", body));
        }
    }

    private String getWysiwygMacroElement(Macro macro) {
        if (macro == null) {
            return "div";
        }
        if (macro.suppressSurroundingTagDuringWysiwygRendering()) {
            return null;
        }
        if (macro.isInline()) {
            return "span";
        }
        return "div";
    }

    private int findEndTagOffset(String wiki, MacroTag startTag) {
        boolean inEscape = false;
        for (int i = startTag.startIndex + startTag.originalText.length(); i < wiki.length(); ++i) {
            char c = wiki.charAt(i);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '{') {
                MacroTag endTag = MacroTag.makeMacroTag(wiki, i);
                if (endTag == null || !startTag.command.equals(endTag.command) || endTag.argString.length() != 0) continue;
                return i;
            }
            if (c != '\\') continue;
            inEscape = true;
        }
        return 0;
    }

    private Macro getMacroByName(String name) {
        if (name == null) {
            return null;
        }
        return this.macroManager.getEnabledMacro(name.toLowerCase());
    }

    private void processMacro(String command, Macro macro, String body, Map params, RenderContext context, StringBuffer buffer) {
        String renderedBody = body;
        try {
            if (TextUtils.stringSet((String)body) && macro.getBodyRenderMode() != null && !macro.getBodyRenderMode().renderNothing()) {
                renderedBody = this.subRenderer.render(body, context, macro.getBodyRenderMode());
            }
            String macroResult = macro.execute(params, renderedBody, context);
            if (macro.getBodyRenderMode() == null) {
                buffer.append(macroResult);
            } else if (macro.isInline()) {
                buffer.append(context.getRenderedContentStore().addInline(macroResult));
            } else {
                buffer.append(context.addRenderedContent(macroResult));
            }
        }
        catch (MacroException e) {
            log.info((Object)("Error formatting macro: " + command + ": " + e), (Throwable)e);
            buffer.append(this.makeMacroError(context, command + ": " + e.getMessage(), body));
        }
        catch (Throwable t) {
            if (this.isJunitError(t)) {
                throw (RuntimeException)t;
            }
            log.error((Object)("Unexpected error formatting macro: " + command), t);
            buffer.append(this.makeMacroError(context, "Error formatting macro: " + command + ": " + t.toString(), body));
        }
    }

    private String makeMacroError(RenderContext context, String errorMessage, String body) {
        return context.addRenderedContent(RenderUtils.blockError(errorMessage, this.renderErrorBody(body, context)));
    }

    private String renderErrorBody(String body, RenderContext context) {
        return context.addRenderedContent(this.subRenderer.render(body, context, null));
    }

    private Map makeParams(String paramString) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(": = | RAW | = :", paramString == null ? "" : paramString);
        if (!TextUtils.stringSet((String)paramString)) {
            return params;
        }
        String[] paramStrs = paramString.split("\\|");
        for (int i = 0; i < paramStrs.length; ++i) {
            String paramStr = paramStrs[i];
            int idx = paramStr.indexOf("=");
            if (idx != -1) {
                if (idx == paramStr.length() - 1) {
                    params.put(paramStr.substring(0, idx).trim(), "");
                    continue;
                }
                params.put(paramStr.substring(0, idx).trim(), paramStr.substring(idx + 1).trim());
                continue;
            }
            params.put(String.valueOf(i), paramStr);
        }
        return params;
    }

    private boolean isJunitError(Throwable t) {
        return t.getClass().getName().startsWith("junit.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

