/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.RendererComponent;
import java.util.regex.Pattern;

public class HtmlEscapeRendererComponent
implements RendererComponent {
    private static final Pattern ENTITY_PATTERN = Pattern.compile("&[#A-Za-z0-9][A-Za-z0-9]+;.*", 32);

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.htmlEscape();
    }

    public String render(String wiki, RenderContext context) {
        return HtmlEscapeRendererComponent.escapeHtml(wiki, context.getRenderMode().preserveEntities());
    }

    public static String escapeHtml(String s, boolean preserveExistingEntities) {
        StringBuffer out = new StringBuffer(s.length() + 50);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    out.append("&gt;");
                    continue block9;
                }
                case '<': {
                    out.append("&lt;");
                    continue block9;
                }
                case '&': {
                    if (preserveExistingEntities && HtmlEscapeRendererComponent.entityAt(s, i)) {
                        out.append('&');
                        continue block9;
                    }
                    out.append("&amp;");
                    continue block9;
                }
                case '\u0091': {
                    out.append("&lsquo;");
                    continue block9;
                }
                case '\u0092': {
                    out.append("&rsquo;");
                    continue block9;
                }
                case '\u0093': {
                    out.append("&ldquo;");
                    continue block9;
                }
                case '\u0094': {
                    out.append("&rdquo;");
                    continue block9;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private static boolean entityAt(String wiki, int start) {
        int end = Math.min(wiki.length(), start + 8);
        String possibleEntity = wiki.substring(start, end);
        return ENTITY_PATTERN.matcher(possibleEntity).matches();
    }
}

