/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.links;

import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.util.RendererProperties;
import java.text.ParseException;
import org.apache.log4j.Category;

public class UrlLink
extends BaseLink {
    private static Category log = Category.getInstance((Class)(class$com$atlassian$renderer$links$UrlLink == null ? (class$com$atlassian$renderer$links$UrlLink = UrlLink.class$("com.atlassian.renderer.links.UrlLink")) : class$com$atlassian$renderer$links$UrlLink));
    public static final String EXTERNAL_ICON = "external";
    public static final String MAILTO_ICON = "mailto";
    static /* synthetic */ Class class$com$atlassian$renderer$links$UrlLink;

    public UrlLink(String url, String linkBody) throws ParseException {
        this(new GenericLinkParser(url));
        this.linkBody = linkBody;
    }

    public UrlLink(GenericLinkParser parser) {
        super(parser);
        this.iconName = EXTERNAL_ICON;
        this.url = parser.getNotLinkBody();
        this.setTitle(RendererProperties.URL_LINK_TITLE);
        if (this.url.startsWith("///")) {
            this.url = this.url.substring(2);
            this.relativeUrl = true;
            this.setTitle(RendererProperties.SITE_RELATIVE_LINK_TITLE);
        } else if (this.url.startsWith("//")) {
            this.url = this.url.substring(1);
            this.setTitle(RendererProperties.RELATIVE_LINK_TITLE);
        }
        if (this.url.startsWith("\\\\")) {
            this.url = "file:" + this.url.replaceAll("\\\\", "/");
        }
        if (this.isMailLink()) {
            if (parser.getLinkBody() == null) {
                this.linkBody = this.linkBody.substring(7);
            }
            this.setTitle("Send mail to " + this.linkBody);
            this.iconName = MAILTO_ICON;
        }
    }

    public boolean isMailLink() {
        return this.url.startsWith("mailto:");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

