/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.links;

import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;

public abstract class BaseLink
extends Link {
    private boolean canSetTitle = true;
    private GenericLinkParser originalParser;

    protected BaseLink(GenericLinkParser parser) {
        super(parser.getOriginalLinkText());
        this.originalParser = parser;
        this.linkBody = parser.getLinkBody() == null ? parser.getNotLinkBody() : parser.getLinkBody();
        if (parser.getLinkTitle() != null) {
            this.title = parser.getLinkTitle();
            this.canSetTitle = false;
        }
    }

    protected void setTitle(String title) {
        if (this.canSetTitle) {
            this.title = title;
        }
    }

    public GenericLinkParser getOriginalParser() {
        return this.originalParser;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        BaseLink link = (BaseLink)o;
        if (link.getUrl() == null || this.getUrl() == null) {
            return link.getUrl() == this.getUrl();
        }
        return link.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 29 * result + (this.getUrl() != null ? this.getUrl().hashCode() : 0);
        return result;
    }
}

