/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.renderer.v2.RenderUtils;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmbeddedImageRenderer
implements EmbeddedResourceRenderer {
    private RendererAttachmentManager attachmentManager;

    public EmbeddedImageRenderer(RendererAttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public RendererAttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(RendererAttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        String token;
        EmbeddedImage image = (EmbeddedImage)resource;
        RendererAttachment attachment = null;
        if (!image.isExternal()) {
            try {
                attachment = this.getAttachment(context, resource);
            }
            catch (RuntimeException re) {
                return context.addRenderedContent(RenderUtils.error(re.getMessage()));
            }
        }
        HashMap<Object, Object> imageParams = new HashMap<Object, Object>();
        imageParams.putAll(image.getProperties());
        if (context.isRenderingForWysiwyg()) {
            imageParams.put("imagetext", resource.getOriginalLinkText());
        }
        if (image.isThumbNail()) {
            token = image.isExternal() ? context.addRenderedContent(RenderUtils.error(context, "Can only create thumbnails for attached images", this.originalLink(resource), false)) : (!this.attachmentManager.systemSupportsThumbnailing() ? context.addRenderedContent(RenderUtils.error(context, "This installation can not generate thumbnails: no image support in Java runtime", this.originalLink(resource), false)) : (attachment == null && !context.isRenderingForWysiwyg() ? context.addRenderedContent(RenderUtils.error(context, "Attachment '" + image.getFilename() + "' was not found", this.originalLink(resource), false)) : context.addRenderedContent(this.generateThumbnail(imageParams, attachment, context, image))));
        } else {
            String imageUrl = "";
            if (image.isExternal()) {
                imageUrl = UrlUtil.escapeSpecialCharacters(image.getUrl());
            } else if (attachment != null) {
                if (context.getOutputType().equals("word")) {
                    String contextPath = context.getSiteRoot();
                    String domain = context.getBaseUrl();
                    if (contextPath != null && contextPath.length() != 0 && domain.indexOf(contextPath) != -1) {
                        domain = domain.substring(0, domain.indexOf(contextPath));
                    }
                    imageUrl = imageUrl + domain;
                }
                imageUrl = imageUrl + attachment.getSrc();
            }
            boolean centered = this.extractCenteredParam(imageParams);
            token = context.addRenderedContent(this.writeImage("<img src=\"" + imageUrl + "\" " + this.outputParameters(imageParams) + "/>", centered));
        }
        return token;
    }

    protected RendererAttachment getAttachment(RenderContext context, EmbeddedResource resource) {
        RendererAttachment attachment = this.attachmentManager.getAttachment(context, resource);
        return attachment;
    }

    private String originalLink(EmbeddedResource resource) {
        return "!" + resource.getOriginalLinkText() + "!";
    }

    private String generateThumbnail(Map imageParams, RendererAttachment attachment, RenderContext context, EmbeddedImage embeddedImage) {
        if (attachment != null && TextUtils.stringSet((String)attachment.getComment()) && !imageParams.containsKey("title") && !imageParams.containsKey("TITLE")) {
            imageParams.put("title", UrlUtil.escapeSpecialCharacters(attachment.getComment()));
        }
        RendererAttachment thumb = null;
        if (attachment != null) {
            try {
                thumb = this.attachmentManager.getThumbnail(attachment, context, embeddedImage);
            }
            catch (RuntimeException re) {
                return context.addRenderedContent(RenderUtils.error(re.getMessage()));
            }
        }
        boolean centered = this.extractCenteredParam(imageParams);
        if (thumb != null) {
            return this.writeImage(thumb.wrapGeneratedElement("<img src='" + thumb.getSrc() + "' " + this.outputParameters(imageParams) + "/>"), centered);
        }
        return this.writeImage("<img " + this.outputParameters(imageParams) + "/>", centered);
    }

    private String writeImage(String imageTag, boolean centered) {
        String result = "";
        if (centered) {
            result = result + "<div align=\"center\">";
        }
        result = result + imageTag;
        if (centered) {
            result = result + "</div>";
        }
        return result;
    }

    private boolean extractCenteredParam(Map imageParams) {
        boolean centered;
        boolean bl = centered = "center".equalsIgnoreCase((String)imageParams.get("align")) || "centre".equalsIgnoreCase((String)imageParams.get("align"));
        if (centered) {
            imageParams.remove("align");
        }
        return centered;
    }

    private String outputParameters(Map params) {
        StringBuffer buff = new StringBuffer(20);
        Iterator iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            buff.append(key + "=\"" + params.get(key) + "\" ");
        }
        if (buff.toString().indexOf("border=") == -1) {
            buff.append(" border='0' ");
        }
        return buff.toString();
    }
}

