/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.embedded;

import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.EmbeddedResourceParser;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class EmbeddedImage
extends EmbeddedResource {
    private boolean isThumbnail;

    public EmbeddedImage(String originalText) {
        this(new EmbeddedResourceParser(originalText));
    }

    public EmbeddedImage(EmbeddedResourceParser parser) {
        super(parser);
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)parser.getProperties());
        if (!this.properties.containsKey("align")) {
            this.properties.put("align", "absmiddle");
        }
        if (!this.properties.containsKey("border")) {
            this.properties.put("border", "0");
        }
        this.isThumbnail = this.properties.containsKey("thumbnail");
        if (this.isThumbnail) {
            this.properties.remove("thumbnail");
        }
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("on") && !key.startsWith("javascript")) continue;
            this.properties.remove(key);
        }
    }

    public static boolean matchesType(EmbeddedResourceParser parser) {
        return parser.getType().startsWith("image");
    }

    public boolean isThumbNail() {
        return this.isThumbnail;
    }
}

