/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedFlashRenderer;
import com.atlassian.renderer.embedded.EmbeddedImageRenderer;
import com.atlassian.renderer.embedded.EmbeddedObjectRenderer;
import com.atlassian.renderer.embedded.EmbeddedRealMediaRenderer;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.embedded.PlaceholderImageRenderer;
import com.atlassian.renderer.embedded.UnembeddableObjectRenderer;
import com.atlassian.renderer.v2.RenderUtils;
import java.util.HashMap;

public class DefaultEmbeddedResourceRenderer
implements EmbeddedResourceRenderer {
    private HashMap renderMap;
    private RendererAttachmentManager attachmentManager;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedImage;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedFlash;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedRealMedia;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedObject;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedQuicktime;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedWindowsMedia;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$EmbeddedAudio;
    static /* synthetic */ Class class$com$atlassian$renderer$embedded$UnembeddableObject;

    public DefaultEmbeddedResourceRenderer() {
    }

    public DefaultEmbeddedResourceRenderer(RendererAttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        try {
            if (resource.isInternal() && this.attachmentManager.getAttachment(context, resource) == null) {
                if (context.isRenderingForWysiwyg()) {
                    return new PlaceholderImageRenderer().renderResource(resource, context);
                }
                throw new IllegalArgumentException("Unable to render embedded object: File (" + resource.getFilename() + ") not found.");
            }
            if (!this.getRenderMap().containsKey(resource.getClass())) {
                if (context.isRenderingForWysiwyg()) {
                    return new PlaceholderImageRenderer().renderResource(resource, context);
                }
                throw new IllegalArgumentException("Unsupported embedded resource type: " + resource.getType());
            }
            EmbeddedResourceRenderer delegate = (EmbeddedResourceRenderer)this.getRenderMap().get(resource.getClass());
            if (context.isRenderingForWysiwyg() && !(class$com$atlassian$renderer$embedded$EmbeddedImage == null ? (class$com$atlassian$renderer$embedded$EmbeddedImage = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedImage")) : class$com$atlassian$renderer$embedded$EmbeddedImage).equals(resource.getClass())) {
                delegate = new PlaceholderImageRenderer();
            }
            return delegate.renderResource(resource, context);
        }
        catch (Exception e) {
            return RenderUtils.error(e.getMessage());
        }
    }

    public RendererAttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(RendererAttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    private HashMap getRenderMap() {
        if (this.renderMap == null) {
            this.renderMap = new HashMap();
            EmbeddedObjectRenderer embeddedObjectRenderer = new EmbeddedObjectRenderer(this.attachmentManager);
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedFlash == null ? (class$com$atlassian$renderer$embedded$EmbeddedFlash = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedFlash")) : class$com$atlassian$renderer$embedded$EmbeddedFlash, new EmbeddedFlashRenderer(this.attachmentManager));
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedImage == null ? (class$com$atlassian$renderer$embedded$EmbeddedImage = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedImage")) : class$com$atlassian$renderer$embedded$EmbeddedImage, new EmbeddedImageRenderer(this.attachmentManager));
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedRealMedia == null ? (class$com$atlassian$renderer$embedded$EmbeddedRealMedia = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedRealMedia")) : class$com$atlassian$renderer$embedded$EmbeddedRealMedia, new EmbeddedRealMediaRenderer(this.attachmentManager));
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedObject == null ? (class$com$atlassian$renderer$embedded$EmbeddedObject = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedObject")) : class$com$atlassian$renderer$embedded$EmbeddedObject, embeddedObjectRenderer);
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedQuicktime == null ? (class$com$atlassian$renderer$embedded$EmbeddedQuicktime = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedQuicktime")) : class$com$atlassian$renderer$embedded$EmbeddedQuicktime, embeddedObjectRenderer);
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedWindowsMedia == null ? (class$com$atlassian$renderer$embedded$EmbeddedWindowsMedia = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedWindowsMedia")) : class$com$atlassian$renderer$embedded$EmbeddedWindowsMedia, embeddedObjectRenderer);
            this.renderMap.put(class$com$atlassian$renderer$embedded$EmbeddedAudio == null ? (class$com$atlassian$renderer$embedded$EmbeddedAudio = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.EmbeddedAudio")) : class$com$atlassian$renderer$embedded$EmbeddedAudio, embeddedObjectRenderer);
            this.renderMap.put(class$com$atlassian$renderer$embedded$UnembeddableObject == null ? (class$com$atlassian$renderer$embedded$UnembeddableObject = DefaultEmbeddedResourceRenderer.class$("com.atlassian.renderer.embedded.UnembeddableObject")) : class$com$atlassian$renderer$embedded$UnembeddableObject, new UnembeddableObjectRenderer());
        }
        return this.renderMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

