/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.Replacer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Category;

public class RenderedContentStore {
    private static Category log = Category.getInstance((Class)(class$com$atlassian$renderer$RenderedContentStore == null ? (class$com$atlassian$renderer$RenderedContentStore = RenderedContentStore.class$("com.atlassian.renderer.RenderedContentStore")) : class$com$atlassian$renderer$RenderedContentStore));
    public static final String BLOCK_TOKEN = "blktokxyzkdtnhgnsbdfblktok";
    public static final String INLINE_TOKEN = "inltokxyzkdtnhgnsbdfinltok";
    public static final String MAP_KEY = "RenderedContentStore";
    private static final Pattern BLOCK_TOKEN_PATTERN = Pattern.compile("blktokxyzkdtnhgnsbdfblktok\\d+blktokxyzkdtnhgnsbdfblktok");
    private static final Pattern INLINE_TOKEN_PATTERN = Pattern.compile("inltokxyzkdtnhgnsbdfinltok\\d+inltokxyzkdtnhgnsbdfinltok");
    private List store = new ArrayList();
    static /* synthetic */ Class class$com$atlassian$renderer$RenderedContentStore;

    public static RenderedContentStore getFromRenderContext(RenderContext renderContext) {
        return renderContext.getRenderedContentStore();
    }

    public String addBlock(Object content) {
        if (!(content instanceof String) && !(content instanceof Renderable)) {
            throw new RuntimeException("You can only store String and Renderable objects.");
        }
        this.store.add(content);
        return BLOCK_TOKEN + (this.store.size() - 1) + BLOCK_TOKEN;
    }

    public String addInline(Object content) {
        if (!(content instanceof String) && !(content instanceof Renderable)) {
            throw new RuntimeException("You can only store String and Renderable objects.");
        }
        this.store.add(content);
        return INLINE_TOKEN + (this.store.size() - 1) + INLINE_TOKEN;
    }

    public Object get(String token) {
        try {
            if (token == null || token.length() < 3) {
                log.warn((Object)"Could not find stored token: the token was null or too short. A filter or macro may be broken.");
                return null;
            }
            int id = Integer.parseInt(token.substring(BLOCK_TOKEN.length(), token.length() - BLOCK_TOKEN.length()));
            return this.store.get(id);
        }
        catch (Exception e) {
            log.warn((Object)("Could not find stored token. A filter or macro may be broken. Exception: " + e.getMessage()));
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderedContentStore)) {
            return false;
        }
        RenderedContentStore renderedContentStore = (RenderedContentStore)o;
        return !(this.store != null ? !((Object)this.store).equals(renderedContentStore.store) : renderedContentStore.store != null);
    }

    public int hashCode() {
        return this.store != null ? ((Object)this.store).hashCode() : 0;
    }

    public static String stripTokens(String text) {
        text = new Replacer(BLOCK_TOKEN_PATTERN, "", new String[0]).replaceAll(text);
        return new Replacer(INLINE_TOKEN_PATTERN, "", new String[0]).replaceAll(text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

