/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer;

import com.atlassian.renderer.RenderContextOutputType;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.v2.RenderMode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Category;

public class RenderContext
implements RenderContextOutputType {
    private static Category log = Category.getInstance((Class)(class$com$atlassian$renderer$RenderContext == null ? (class$com$atlassian$renderer$RenderContext = RenderContext.class$("com.atlassian.renderer.RenderContext")) : class$com$atlassian$renderer$RenderContext));
    private Stack renderModes = new Stack();
    private RenderedContentStore store;
    private String baseUrl;
    private String siteRoot;
    private String imagePath;
    private String attachmentsPath;
    private String characterEncoding;
    private LinkRenderer linkRenderer;
    private EmbeddedResourceRenderer resourceRenderer;
    private boolean renderingForWysiwyg;
    private List externalReferences = new LinkedList();
    private Map parameters = new HashMap();
    private String outputType;
    static /* synthetic */ Class class$com$atlassian$renderer$RenderContext;

    public RenderContext() {
        this(new RenderedContentStore());
    }

    protected RenderContext(RenderedContentStore store) {
        this.renderModes.push(RenderMode.ALL);
        this.store = store == null ? new RenderedContentStore() : store;
    }

    public RenderMode getRenderMode() {
        if (this.renderModes.empty()) {
            return RenderMode.ALL;
        }
        return (RenderMode)this.renderModes.peek();
    }

    public void pushRenderMode(RenderMode renderMode) {
        this.renderModes.push(renderMode);
    }

    public RenderMode popRenderMode() {
        if (this.renderModes.empty()) {
            log.warn((Object)"Render mode stack is empty!", (Throwable)new Exception("Render mode stack is empty"));
            return RenderMode.ALL;
        }
        return (RenderMode)this.renderModes.pop();
    }

    public RenderedContentStore getRenderedContentStore() {
        return this.store;
    }

    public String addRenderedContent(Object content) {
        return this.store.addBlock(content);
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public void setSiteRoot(String siteRoot) {
        this.siteRoot = siteRoot;
    }

    public String getSiteRoot() {
        return this.siteRoot;
    }

    public void setLinkRenderer(LinkRenderer linkRenderer) {
        this.linkRenderer = linkRenderer;
    }

    public LinkRenderer getLinkRenderer() {
        return this.linkRenderer;
    }

    public void setEmbeddedResourceRenderer(EmbeddedResourceRenderer renderer) {
        this.resourceRenderer = renderer;
    }

    public EmbeddedResourceRenderer getEmbeddedResourceRenderer() {
        return this.resourceRenderer;
    }

    public String getAttachmentsPath() {
        return this.attachmentsPath;
    }

    public void setAttachmentsPath(String attachmentsPath) {
        this.attachmentsPath = attachmentsPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderContext)) {
            return false;
        }
        RenderContext renderContext = (RenderContext)o;
        if (this.imagePath != null ? !this.imagePath.equals(renderContext.imagePath) : renderContext.imagePath != null) {
            return false;
        }
        if (this.renderModes != null ? !this.renderModes.equals(renderContext.renderModes) : renderContext.renderModes != null) {
            return false;
        }
        return !(this.store != null ? !this.store.equals(renderContext.store) : renderContext.store != null);
    }

    public int hashCode() {
        int result = this.renderModes != null ? this.renderModes.hashCode() : 0;
        result = 29 * result + (this.store != null ? this.store.hashCode() : 0);
        result = 29 * result + (this.imagePath != null ? this.imagePath.hashCode() : 0);
        return result;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isRenderingForWysiwyg() {
        return this.renderingForWysiwyg;
    }

    public void setRenderingForWysiwyg(boolean renderingForWysiwyg) {
        this.renderingForWysiwyg = renderingForWysiwyg;
    }

    public void addExternalReference(Link link) {
        if (!this.externalReferences.contains(link)) {
            this.externalReferences.add(link);
        }
    }

    public List getExternalReferences() {
        return this.externalReferences;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public Map getParams() {
        return this.parameters;
    }

    public void addParam(Object key, Object value) {
        this.parameters.put(key, value);
    }

    public Object getParam(Object key) {
        return this.parameters.get(key);
    }

    public String getOutputType() {
        if (this.outputType == null) {
            return "display";
        }
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

