/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer;

import com.atlassian.renderer.Icon;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.util.RendererProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultIconManager
implements IconManager {
    private Map iconsMap;
    private String[] emoticons;
    private Map emoticonsMap;

    public Icon getLinkDecoration(String iconName) {
        if (this.getIconsMap().containsKey(iconName)) {
            return (Icon)this.getIconsMap().get(iconName);
        }
        return Icon.NULL_ICON;
    }

    public Icon getEmoticon(String symbol) {
        if (this.getEmoticonsMap().containsKey(symbol)) {
            return (Icon)this.getEmoticonsMap().get(symbol);
        }
        return Icon.NULL_ICON;
    }

    public String[] getEmoticonSymbols() {
        if (this.emoticons == null) {
            String[] tmpEmoticons = new String[this.getEmoticonsMap().size()];
            int i = 0;
            Iterator it = this.getEmoticonsMap().keySet().iterator();
            while (it.hasNext()) {
                String key;
                tmpEmoticons[i] = key = (String)it.next();
                ++i;
            }
            this.emoticons = tmpEmoticons;
        }
        return this.emoticons;
    }

    protected Map getIconsMap() {
        if (this.iconsMap == null) {
            this.iconsMap = new HashMap();
            this.iconsMap.put("mailto", Icon.makeRenderIcon(RendererProperties.ICONS_PATH + "mail_small.gif", 1, 12, 13));
            this.iconsMap.put("external", Icon.makeRenderIcon(RendererProperties.ICONS_PATH + "linkext7.gif", 1, 7, 7));
        }
        return this.iconsMap;
    }

    protected synchronized Map getEmoticonsMap() {
        if (this.emoticonsMap == null) {
            this.emoticonsMap = new HashMap();
            this.emoticonsMap.put(":-)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "smile.gif", 20, 20));
            this.emoticonsMap.put(":)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "smile.gif", 20, 20));
            this.emoticonsMap.put(":P", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "tongue.gif", 20, 20));
            this.emoticonsMap.put(":p", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "tongue.gif", 20, 20));
            this.emoticonsMap.put(";-)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "wink.gif", 20, 20));
            this.emoticonsMap.put(";)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "wink.gif", 20, 20));
            this.emoticonsMap.put(":D", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "biggrin.gif", 20, 20));
            this.emoticonsMap.put(":-(", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "sad.gif", 20, 20));
            this.emoticonsMap.put(":(", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "sad.gif", 20, 20));
            this.emoticonsMap.put("(y)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "thumbs_up.gif", 19, 19));
            this.emoticonsMap.put("(n)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "thumbs_down.gif", 19, 19));
            this.emoticonsMap.put("(i)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "information.gif", 16, 16));
            this.emoticonsMap.put("(/)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "check.gif", 16, 16));
            this.emoticonsMap.put("(x)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "error.gif", 16, 16));
            this.emoticonsMap.put("(+)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "add.gif", 16, 16));
            this.emoticonsMap.put("(-)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "forbidden.gif", 16, 16));
            this.emoticonsMap.put("(!)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "warning.gif", 16, 16));
            this.emoticonsMap.put("(?)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "help_16.gif", 16, 16));
            this.emoticonsMap.put("(on)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "lightbulb_on.gif", 16, 16));
            this.emoticonsMap.put("(off)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "lightbulb.gif", 16, 16));
            this.emoticonsMap.put("(*)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "star_yellow.gif", 16, 16));
            this.emoticonsMap.put("(*b)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "star_blue.gif", 16, 16));
            this.emoticonsMap.put("(*y)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "star_yellow.gif", 16, 16));
            this.emoticonsMap.put("(*g)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "star_green.gif", 16, 16));
            this.emoticonsMap.put("(*r)", Icon.makeEmoticon(RendererProperties.EMOTICONS_PATH + "star_red.gif", 16, 16));
        }
        return this.emoticonsMap;
    }
}

