/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.DataAccessPointException;
import org.hsqldb.util.JDBCTypes;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferResultSet;
import org.hsqldb.util.TransferTable;

class TransferSQLText
extends DataAccessPoint {
    String sFileName = null;
    BufferedWriter WTextWrite = null;
    BufferedReader WTextRead = null;
    protected boolean StructureAlreadyParsed = false;
    Hashtable DbStmts = null;
    protected JDBCTypes JDBCT = null;

    TransferSQLText(String string, Traceable traceable) throws DataAccessPointException {
        super(traceable);
        this.sFileName = string;
        this.JDBCT = new JDBCTypes();
        if (this.sFileName == null) {
            throw new DataAccessPointException("File name not initialized");
        }
    }

    boolean execute(String string) throws DataAccessPointException {
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        try {
            this.WTextWrite.write(string + "\n");
            this.WTextWrite.flush();
        }
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void putData(String string, TransferResultSet transferResultSet, int n) throws DataAccessPointException {
        int n2 = 0;
        if (transferResultSet == null) {
            return;
        }
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        try {
            try {}
            catch (Exception exception) {
                throw new DataAccessPointException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (n2 <= 0) throw throwable;
                this.WTextWrite.write("\tNumber of Rows=" + n2 + "\n\n");
                this.WTextWrite.flush();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        while (transferResultSet.next()) {
            if (n2 == 0) {
                this.WTextWrite.write(string + "\n");
                this.WTextWrite.flush();
            }
            this.transferRow(transferResultSet);
            if (n != 0 && n2 == n) break;
            if (n == 0 && ++n2 % 100 != 0) continue;
            this.tracer.trace("Transfered " + n2 + " rows");
        }
        Object var7_7 = null;
        try {}
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
        if (n2 <= 0) return;
        this.WTextWrite.write("\tNumber of Rows=" + n2 + "\n\n");
        this.WTextWrite.flush();
    }

    void close() throws DataAccessPointException {
        if (this.WTextWrite != null) {
            try {
                this.WTextWrite.flush();
                this.WTextWrite.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void transferRow(TransferResultSet transferResultSet) throws Exception {
        String string = "";
        int n = transferResultSet.getColumnCount();
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        for (int i = 0; i < n; ++i) {
            int n2 = transferResultSet.getColumnType(i + 1);
            string = "column=" + transferResultSet.getColumnName(i + 1) + " datatype=" + (String)this.helper.getSupportedTypes().get(new Integer(n2));
            Object object = transferResultSet.getObject(i + 1);
            if (object == null) {
                string = string + " value=<null>";
            } else {
                object = this.helper.convertColumnValue(object, i + 1, n2);
                string = string + " value='" + object.toString() + "'";
            }
            this.WTextWrite.write("\t" + string + "\n");
            this.WTextWrite.flush();
        }
        this.WTextWrite.write("\n");
        this.WTextWrite.flush();
        string = "";
    }

    ColumnDef getColumnDef(String string, int n) {
        int n2 = 0;
        ColumnDef columnDef = new ColumnDef();
        columnDef.start = n;
        if (string == null || string.length() == 0 || n >= string.length()) {
            return new ColumnDef();
        }
        String string2 = string.substring(n);
        try {
            char c;
            int n3;
            for (n3 = 0; n3 < string2.length() && ((c = string2.charAt(n3)) == ',' || c == ' ' || c == ')' || c == ';'); ++n3) {
            }
            if (n3 == string2.length()) {
                return new ColumnDef();
            }
            columnDef.len += n3;
            string2 = string2.substring(n3);
            while (string2.charAt(n2) != ' ') {
                ++n2;
            }
            columnDef.columnName = string2.substring(0, n2);
            string2 = string2.substring(n2);
            columnDef.len += n2;
            n2 = 0;
            if (!columnDef.columnName.toUpperCase().equals("CONSTRAINT")) {
                for (n3 = 0; n3 < string2.length() && string2.charAt(n3) == ' '; ++n3) {
                }
                string2 = string2.substring(n3);
                columnDef.len += n3;
                while (string2.charAt(n2) != '(' && string2.charAt(n2) != ',' && string2.charAt(n2) != ')' && string2.charAt(n2) != ';' && string2.charAt(n2) != ' ') {
                    ++n2;
                }
                columnDef.columnType = string2.substring(0, n2).toUpperCase();
                string2 = string2.substring(n2);
                columnDef.len += n2;
                n2 = 0;
            }
            while (string2.charAt(n2) != ',' && string2.charAt(n2) != ';' && n2 < string2.length() && string2.charAt(n2) != ')') {
                if (string2.charAt(n2) == '(') {
                    while (string2.charAt(n2) != ')') {
                        ++n2;
                    }
                }
                ++n2;
            }
            columnDef.options = string2.substring(0, n2);
            columnDef.len += n2;
        }
        catch (Exception exception) {
            columnDef = new ColumnDef();
        }
        return columnDef;
    }

    String translateTypes(String string, TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        String string2 = "";
        JDBCTypes jDBCTypes = new JDBCTypes();
        int n = 0;
        String string3 = "";
        String string4 = "";
        int n2 = 0;
        n = string.indexOf(40) + 1;
        string2 = string.substring(0, n);
        while (true) {
            ColumnDef columnDef = this.getColumnDef(string, n);
            if (columnDef.len == 0) break;
            string3 = columnDef.columnName;
            string4 = columnDef.columnType;
            if (string3.toUpperCase().indexOf("CONSTRAINT") >= 0) {
                string2 = string2 + string.substring(n, n + columnDef.len) + ",";
                n += columnDef.len + 1;
                ++n2;
                continue;
            }
            string3 = dataAccessPoint.helper.formatIdentifier(string3) + " ";
            try {
                Integer n3 = new Integer(dataAccessPoint.helper.convertToType(jDBCTypes.toInt(string4)));
                string4 = (String)transferTable.hTypes.get(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (columnDef.options != null) {
                string4 = string4 + columnDef.options;
            }
            try {
                string4 = dataAccessPoint.helper.fixupColumnDefWrite(transferTable, null, string4, null, n2);
            }
            catch (SQLException sQLException) {
                return string;
            }
            string2 = string2 + string3 + " " + string4 + ",";
            n += columnDef.len + 1;
            ++n2;
        }
        return string2.substring(0, string2.length() - 1) + ");";
    }

    void parseFileForTables() throws DataAccessPointException {
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        TransferTable transferTable = null;
        try {
            while ((string = this.WTextRead.readLine()) != null) {
                string = string.trim() + ";";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                try {
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                if (string2 == null || !string2.toUpperCase().equals("CREATE") || !(string2 = stringTokenizer.nextToken().toUpperCase()).equals("TABLE") && !string2.equals("VIEW")) continue;
                try {
                    string3 = stringTokenizer.nextToken(" (;");
                    transferTable = new TransferTable(this, string3, "", string2, this.tracer);
                    transferTable.Stmts.bCreate = false;
                    transferTable.Stmts.bDelete = false;
                    transferTable.Stmts.bDrop = false;
                    transferTable.Stmts.bCreateIndex = false;
                    transferTable.Stmts.bDropIndex = false;
                    transferTable.Stmts.bInsert = false;
                    transferTable.Stmts.bAlter = false;
                    this.DbStmts.put(transferTable.Stmts.sSourceTable, transferTable);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
        catch (Exception exception) {
            throw new DataAccessPointException(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseFileForTheRest(TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        this.StructureAlreadyParsed = true;
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        TransferTable transferTable2 = null;
        try {
            while ((string = this.WTextRead.readLine()) != null) {
                string = string.trim() + ";";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                try {
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                if (string2 == null) continue;
                if (string2.toUpperCase().equals("INSERT")) {
                    try {
                        if (!stringTokenizer.nextToken().toUpperCase().equals("INTO")) {
                            throw new DataAccessPointException("Error in INSERT statement: no INTO found");
                        }
                        string2 = stringTokenizer.nextToken();
                        transferTable2 = (TransferTable)this.DbStmts.get(string2);
                        if (transferTable2 == null) continue;
                        transferTable2.Stmts.bDelete = true;
                        transferTable2.Stmts.bInsert = true;
                        transferTable2.Stmts.sDestInsert = string;
                        transferTable2.Stmts.sDestDelete = "DELETE FROM " + transferTable2.Stmts.sSourceTable + ";";
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    continue;
                }
                if (string2.toUpperCase().equals("ALTER")) {
                    try {
                        if (!stringTokenizer.nextToken().toUpperCase().equals("TABLE")) continue;
                        string3 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken().toUpperCase();
                        if (!string2.equals("ADD")) continue;
                        while (!(string2 = stringTokenizer.nextToken().toUpperCase()).equals("CONSTRAINT")) {
                        }
                        transferTable2 = (TransferTable)this.DbStmts.get(string3);
                        if (transferTable2 == null) {
                            throw new DataAccessPointException("table not found");
                        }
                        if (transferTable2.Stmts.sDestAlter == null) {
                            transferTable2.Stmts.sDestAlter = "";
                        }
                        transferTable2.Stmts.bAlter = true;
                        transferTable2.Stmts.sDestAlter = transferTable2.Stmts.sDestAlter + string;
                        string2 = stringTokenizer.nextToken();
                        if (transferTable2.Stmts.sDestDrop == null) {
                            transferTable2.Stmts.sDestDrop = "";
                        }
                        transferTable2.Stmts.bDrop = true;
                        transferTable2.Stmts.sDestDrop = "ALTER TABLE " + string3 + " DROP CONSTRAINT " + string2 + ";" + transferTable2.Stmts.sDestDrop;
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    continue;
                }
                if (!string2.toUpperCase().equals("CREATE")) continue;
                string2 = stringTokenizer.nextToken().toUpperCase();
                if (string2.equals("TABLE") || string2.equals("VIEW")) {
                    try {
                        string3 = stringTokenizer.nextToken(" (;");
                        if (!this.DbStmts.containsKey(string3)) {
                            throw new DataAccessPointException("error: index is created before the table");
                        }
                        transferTable2 = (TransferTable)this.DbStmts.get(string3);
                        transferTable2.Stmts.bCreate = true;
                        transferTable2.Stmts.bDrop = true;
                        transferTable2.Stmts.sDestCreate = this.translateTypes(string, transferTable, dataAccessPoint);
                        transferTable2.Stmts.sDestDrop = "DROP " + transferTable2.Stmts.sType + " " + string3 + ";";
                        this.DbStmts.put(transferTable2.Stmts.sSourceTable, transferTable2);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        continue;
                    }
                }
                if (!string2.equals("INDEX") && !string2.equals("UNIQUE")) continue;
                try {
                    while ((string2 = stringTokenizer.nextToken()).toUpperCase().equals("INDEX")) {
                    }
                    String string4 = "DROP INDEX " + string2 + " ;";
                    while ((string2 = stringTokenizer.nextToken(" (")).toUpperCase().equals("ON")) {
                    }
                    string3 = string2;
                    if (!this.DbStmts.containsKey(string2)) {
                        throw new DataAccessPointException("error: index is created before the table");
                    }
                    transferTable2 = (TransferTable)this.DbStmts.get(string2);
                    if (transferTable2.Stmts.sDestCreateIndex == null) {
                        transferTable2.Stmts.sDestCreateIndex = "";
                    }
                    if (transferTable2.Stmts.sDestDropIndex == null) {
                        transferTable2.Stmts.sDestDropIndex = "";
                    }
                    transferTable2.Stmts.bCreateIndex = true;
                    transferTable2.Stmts.bDropIndex = true;
                    transferTable2.Stmts.sDestCreateIndex = transferTable2.Stmts.sDestCreateIndex + string;
                    transferTable2.Stmts.sDestDropIndex = transferTable2.Stmts.sDestDropIndex + string4;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            return;
        }
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
    }

    Vector getTables(String string, String[] stringArray) throws DataAccessPointException {
        Vector vector = new Vector();
        if (this.DbStmts == null) {
            this.DbStmts = new Hashtable();
        }
        if (this.WTextRead != null) {
            try {
                this.WTextRead.close();
                this.WTextRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.parseFileForTables();
        this.StructureAlreadyParsed = false;
        Enumeration enumeration = this.DbStmts.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    void getTableStructure(TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        if (!this.StructureAlreadyParsed) {
            if (this.WTextRead != null) {
                try {
                    this.WTextRead.close();
                    this.WTextRead = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.parseFileForTheRest(transferTable, dataAccessPoint);
        }
    }

    TransferResultSet getData(String string) throws DataAccessPointException {
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (!stringTokenizer.nextToken().toUpperCase().equals("FROM")) {
            }
            string2 = stringTokenizer.nextToken(" ;");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataAccessPointException("Table name not found in statement: " + string);
        }
        if (this.WTextRead != null) {
            try {
                this.WTextRead.close();
                this.WTextRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.parseFileForData(string2);
    }

    TransferResultSet parseFileForData(String string) throws DataAccessPointException {
        TransferResultSet transferResultSet = new TransferResultSet();
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        String string2 = "";
        try {
            while ((string2 = this.WTextRead.readLine()) != null) {
                String string3;
                string2 = string2.trim() + ";";
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                try {
                    string3 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                if (string3 == null || !string3.toUpperCase().equals("INSERT")) continue;
                try {
                    if (!stringTokenizer.nextToken().toUpperCase().equals("INTO")) {
                        throw new DataAccessPointException("Error in INSERT statement: no INTO found");
                    }
                    string3 = stringTokenizer.nextToken();
                    if (!string3.equals(string)) continue;
                    int n = 0;
                    Vector<String> vector = new Vector<String>();
                    Vector<String> vector2 = new Vector<String>();
                    Vector<Integer> vector3 = new Vector<Integer>();
                    while ((string2 = this.WTextRead.readLine()) != null) {
                        Object object;
                        Object object2;
                        int n2;
                        boolean bl;
                        boolean bl2 = bl = (string2 = string2.trim()).length() == 0;
                        if (bl) {
                            n2 = 0;
                            ++n;
                            n2 = vector.size();
                            object2 = new String[n2 + 1];
                            int[] nArray = new int[n2 + 1];
                            object = new Object[n2 + 1];
                            for (int i = 0; i < n2; ++i) {
                                object2[i + 1] = (String)vector.elementAt(i);
                                nArray[i + 1] = (Integer)vector3.elementAt(i);
                                object[i + 1] = vector2.elementAt(i);
                            }
                            try {
                                transferResultSet.addRow((String[])object2, nArray, (Object[])object, n2);
                            }
                            catch (Exception exception) {
                                throw new DataAccessPointException(exception.getMessage());
                            }
                            n2 = 0;
                            vector.removeAllElements();
                            vector2.removeAllElements();
                            vector3.removeAllElements();
                            continue;
                        }
                        stringTokenizer = new StringTokenizer(string2);
                        string3 = stringTokenizer.nextToken("=");
                        if (string3.equals("Number of Rows")) {
                            n2 = Integer.parseInt(stringTokenizer.nextToken());
                            if (n2 != n) {
                                throw new DataAccessPointException("Number of parsed rows (" + n + ") is different from the expected (" + n2 + ")");
                            }
                            return transferResultSet;
                        }
                        if (string3.equals("column")) {
                            string3 = stringTokenizer.nextToken(" =");
                            vector.addElement(string3);
                        }
                        if ((string3 = stringTokenizer.nextToken(" =")).equals("datatype")) {
                            string3 = stringTokenizer.nextToken(" =");
                            try {
                                n2 = this.JDBCT.toInt(string3.toUpperCase());
                            }
                            catch (Exception exception) {
                                throw new DataAccessPointException("Unknown type: " + string3);
                            }
                            vector3.addElement(new Integer(n2));
                        }
                        if (!(string3 = stringTokenizer.nextToken(" =")).equals("value")) continue;
                        n2 = string2.indexOf("value=") + 6;
                        object2 = string2.substring(n2).trim();
                        if (((String)object2).indexOf("<null>") >= 0) {
                            vector2.addElement(null);
                            continue;
                        }
                        int n3 = ((String)object2).indexOf(39) + 1;
                        object = ((String)object2).substring(n3);
                        n3 = ((String)object).lastIndexOf(39);
                        object = ((String)object).substring(0, n3);
                        string3 = ((String)object).toString();
                        vector2.addElement(string3);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
            }
        }
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
        return transferResultSet;
    }

    class ColumnDef {
        String columnName = "";
        String columnType = "";
        String options = "";
        int start = 0;
        int len = 0;
    }
}

