/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;

class DatabaseManagerCommon {
    private static Random rRandom = new Random(100L);
    static String[] selectHelp = new String[]{"SELECT * FROM ", "SELECT [LIMIT n m] [DISTINCT] \n{ selectExpression | table.* | * } [, ... ] \n[INTO [CACHED|TEMP|TEXT] newTable] \nFROM tableList \n[WHERE Expression] \n[ORDER BY selectExpression [{ASC | DESC}] [, ...] ] \n[GROUP BY Expression [, ...] ] \n[UNION [ALL] selectStatement]"};
    static String[] insertHelp = new String[]{"INSERT INTO ", "INSERT INTO table [ (column [,...] ) ] \n{ VALUES(Expression [,...]) | SelectStatement }"};
    static String[] updateHelp = new String[]{"UPDATE ", "UPDATE table SET column = Expression [, ...] \n[WHERE Expression]"};
    static String[] deleteHelp = new String[]{"DELETE FROM ", "DELETE FROM table [WHERE Expression]"};
    static String[] createTableHelp = new String[]{"CREATE TABLE ", "CREATE [TEMP] [CACHED|MEMORY|TEXT] TABLE name \n( columnDefinition [, ...] ) \n\ncolumnDefinition: \ncolumn DataType [ [NOT] NULL] [PRIMARY KEY] \nDataType: \n{ INTEGER | DOUBLE | VARCHAR | DATE | TIME |... }"};
    static String[] dropTableHelp = new String[]{"DROP TABLE ", "DROP TABLE table"};
    static String[] createIndexHelp = new String[]{"CREATE INDEX ", "CREATE [UNIQUE] INDEX index ON \ntable (column [, ...])"};
    static String[] dropIndexHelp = new String[]{"DROP INDEX ", "DROP INDEX table.index"};
    static String[] checkpointHelp = new String[]{"CHECKPOINT", "(HSQLDB SQL only)"};
    static String[] scriptHelp = new String[]{"SCRIPT", "SCRIPT ['file']\n\n(HSQLDB SQL only)"};
    static String[] shutdownHelp = new String[]{"SHUTDOWN", "SHUTDOWN [COMPACT|IMMEDIATELY]\n\n(HSQLDB SQL only)"};
    static String[] setHelp = new String[]{"SET ", "AUTOCOMMIT { TRUE | FALSE }\nIGNORECASE { TRUE | FALSE }\nLOGSIZE size\nMAXROWS maxrows\nPASSWORD password\nREADONLY { TRUE | FALSE }\nREFERENTIAL_INTEGRITY { TRUE | FALSE }\nTABLE table READONLY { TRUE | FALSE }\nTABLE table SOURCE \"file\" [DESC]\nWRITE_DELAY { TRUE | FALSE }\n\n(HSQLDB SQL only)"};
    static String[] testHelp = new String[]{"-->>>TEST<<<-- ;\n--#1000;\nDROP TABLE Test ;\nCREATE TABLE Test(\n  Id INTEGER PRIMARY KEY,\n  FirstName VARCHAR(20),\n  Name VARCHAR(50),\n  ZIP INTEGER) ;\nINSERT INTO Test \n  VALUES(#,'Julia','Peterson-Clancy',#) ;\nUPDATE Test SET Name='Hans' WHERE Id=# ;\nSELECT * FROM Test WHERE Id=# ;\nDELETE FROM Test WHERE Id=# ;\nDROP TABLE Test", "This test script is parsed by the DatabaseManager\nIt may be changed manually. Rules:\n- it must start with -->>>TEST<<<--.\n- each line must end with ';' (no spaces after)\n- lines starting with -- are comments\n- lines starting with --#<count> means set new count\n"};
    static String[] testDataSql = new String[]{"SELECT * FROM Product", "SELECT * FROM Invoice", "SELECT * FROM Item", "SELECT * FROM Customer a INNER JOIN Invoice i ON a.ID=i.CustomerID", "SELECT * FROM Customer a LEFT OUTER JOIN Invoice i ON a.ID=i.CustomerID", "SELECT * FROM Invoice d INNER JOIN Item i ON d.ID=i.InvoiceID", "SELECT * FROM Customer WHERE Street LIKE '1%' ORDER BY Lastname"};

    static String random(String[] stringArray) {
        return stringArray[DatabaseManagerCommon.random(stringArray.length)];
    }

    static int random(int n) {
        n = rRandom.nextInt() % n;
        return n < 0 ? -n : n;
    }

    static void createTestTables(Statement statement) {
        String[] stringArray = new String[]{"DROP TABLE Item IF EXISTS;", "DROP TABLE Invoice IF EXISTS;", "DROP TABLE Product IF EXISTS;", "DROP TABLE Customer IF EXISTS;", "CREATE TABLE Customer(ID INTEGER PRIMARY KEY,FirstName VARCHAR,LastName VARCHAR,Street VARCHAR,City VARCHAR);", "CREATE TABLE Product(ID INTEGER PRIMARY KEY,Name VARCHAR,Price DECIMAL);", "CREATE TABLE Invoice(ID INTEGER PRIMARY KEY,CustomerID INTEGER,Total DECIMAL, FOREIGN KEY (CustomerId) REFERENCES Customer(ID) ON DELETE CASCADE);", "CREATE TABLE Item(InvoiceID INTEGER,Item INTEGER,ProductID INTEGER,Quantity INTEGER,Cost DECIMAL,PRIMARY KEY(InvoiceID,Item), FOREIGN KEY (InvoiceId) REFERENCES Invoice (ID) ON DELETE CASCADE, FOREIGN KEY (ProductId) REFERENCES Product(ID) ON DELETE CASCADE);"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                statement.execute(stringArray[i]);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static String createTestData(Statement statement) throws SQLException {
        String[] stringArray = new String[]{"White", "Karsen", "Smith", "Ringer", "May", "King", "Fuller", "Miller", "Ott", "Sommer", "Schneider", "Steel", "Peterson", "Heiniger", "Clancy"};
        String[] stringArray2 = new String[]{"Mary", "James", "Anne", "George", "Sylvia", "Robert", "Janet", "Michael", "Andrew", "Bill", "Susanne", "Laura", "Bob", "Julia", "John"};
        String[] stringArray3 = new String[]{"Upland Pl.", "College Av.", "- 20th Ave.", "Seventh Av."};
        String[] stringArray4 = new String[]{"New York", "Dallas", "Boston", "Chicago", "Seattle", "San Francisco", "Berne", "Oslo", "Paris", "Lyon", "Palo Alto", "Olten"};
        String[] stringArray5 = new String[]{"Iron", "Ice Tea", "Clock", "Chair", "Telephone", "Shoe"};
        int n = 50;
        statement.execute("SET REFERENTIAL_INTEGRITY FALSE");
        for (int i = 0; i < n; ++i) {
            statement.execute("INSERT INTO Customer VALUES(" + i + ",'" + DatabaseManagerCommon.random(stringArray2) + "','" + DatabaseManagerCommon.random(stringArray) + "','" + DatabaseManagerCommon.random(554) + " " + DatabaseManagerCommon.random(stringArray3) + "','" + DatabaseManagerCommon.random(stringArray4) + "')");
            statement.execute("INSERT INTO Product VALUES(" + i + ",'" + DatabaseManagerCommon.random(stringArray5) + " " + DatabaseManagerCommon.random(stringArray5) + "'," + (20 + 2 * DatabaseManagerCommon.random(120)) + ")");
            statement.execute("INSERT INTO Invoice VALUES(" + i + "," + DatabaseManagerCommon.random(n) + ",0.0)");
            for (int j = DatabaseManagerCommon.random(20) + 2; j >= 0; --j) {
                statement.execute("INSERT INTO Item VALUES(" + i + "," + j + "," + DatabaseManagerCommon.random(n) + "," + (1 + DatabaseManagerCommon.random(24)) + ",1.5)");
            }
        }
        statement.execute("SET REFERENTIAL_INTEGRITY TRUE");
        statement.execute("UPDATE Product SET Price=ROUND(Price*.1,2)");
        statement.execute("UPDATE Item SET Cost=Cost*SELECT Price FROM Product prod WHERE ProductID=prod.ID");
        statement.execute("UPDATE Invoice SET Total=SELECT SUM(Cost*Quantity) FROM Item WHERE InvoiceID=Invoice.ID");
        return "SELECT * FROM Customer";
    }

    static String readFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    static void writeFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2.toCharArray());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static long testStatement(Statement statement, String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        if (string.indexOf(35) == -1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            String string2 = string;
            while ((n2 = string2.indexOf("#r#")) != -1) {
                string2 = string2.substring(0, n2) + (int)(Math.random() * (double)i) + string2.substring(n2 + 3);
            }
            while ((n2 = string2.indexOf(35)) != -1) {
                string2 = string2.substring(0, n2) + i + string2.substring(n2 + 1);
            }
            statement.execute(string2);
        }
        return System.currentTimeMillis() - l;
    }

    private DatabaseManagerCommon() {
    }
}

