/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcResultSet;

public class jdbcStatement
implements Statement {
    private boolean bEscapeProcessing = true;
    private jdbcConnection cConnection;
    private int iMaxRows;
    private jdbcResultSet rSet;
    private int rsType = 1003;

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        this.fetchResult(string);
        return this.rSet;
    }

    public int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        this.fetchResult(string);
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public void close() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.closeOldResult();
        this.rSet = null;
    }

    public int getMaxFieldSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 0;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public int getMaxRows() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return this.iMaxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        this.iMaxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        this.bEscapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 0;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public void cancel() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public void setCursorName(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public boolean execute(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        this.fetchResult(string);
        if (this.rSet == null) {
            return false;
        }
        return this.rSet.isResult();
    }

    public ResultSet getResultSet() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (this.rSet != null && this.rSet.isResult()) {
            return this.rSet;
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        if (n != 1000) {
            throw Trace.error(20);
        }
    }

    public int getFetchDirection() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public int getFetchSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return this.rsType;
    }

    public void addBatch(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    public void clearBatch() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw Trace.error(20);
    }

    public int[] executeBatch() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        throw Trace.error(20);
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.cConnection;
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public boolean execute(String string, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public int getResultSetHoldability() throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    jdbcStatement(jdbcConnection jdbcConnection2) {
        this.cConnection = jdbcConnection2;
        this.rsType = 1003;
    }

    jdbcStatement(jdbcConnection jdbcConnection2, int n) {
        this(jdbcConnection2);
        this.rsType = n;
    }

    void checkClosed() throws SQLException {
        this.cConnection.checkClosed();
    }

    private void closeOldResult() throws SQLException {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
    }

    private void fetchResult(String string) throws SQLException {
        if (this.bEscapeProcessing) {
            string = this.cConnection.nativeSQL(string);
        }
        this.closeOldResult();
        if (this.iMaxRows == 0) {
            this.rSet = this.cConnection.execute(string);
        } else {
            try {
                string = "SET MAXROWS " + this.iMaxRows + ";" + string;
                this.rSet = this.cConnection.execute(string);
                this.cConnection.execute("SET MAXROWS 0");
            }
            catch (SQLException sQLException) {
                this.cConnection.execute("SET MAXROWS 0");
                throw sQLException;
            }
        }
        if (this.rSet != null) {
            this.rSet.sqlStatement = this;
            this.rSet.rsType = this.rsType;
        }
    }
}

