/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.hsqldb.ByteArray;
import org.hsqldb.Column;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcStatement;
import org.hsqldb.lib.HsqlDateTime;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement,
CallableStatement {
    private String sSql;
    private Vector vParameter;

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public ResultSet executeQuery() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.executeQuery(this.build());
    }

    public int executeUpdate() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.executeUpdate(this.build());
    }

    public void setNull(int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setNull(n);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, bl ? "TRUE" : "FALSE");
    }

    public void setByte(int n, byte by) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(by));
    }

    public void setShort(int n, short s) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(s));
    }

    public void setInt(int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, String.valueOf(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(f));
    }

    public void setDouble(int n, double d) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(bigDecimal, 3));
    }

    public void setString(int n, String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(string));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (byArray == null) {
            this.setNull(n);
        } else {
            this.setParameter(n, Column.createSQLString(StringConverter.byteToHex(byArray)));
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(date, 91));
    }

    public void setTime(int n, Time time) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(time, 92));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setParameter(n, Column.createSQLString(timestamp, 93));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (inputStream == null) {
            this.setNull(n);
        } else {
            this.setString(n, StringConverter.inputStreamToString(inputStream));
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        StringBuffer stringBuffer = new StringBuffer(n2 / 2);
        try {
            int n3;
            int n4;
            for (int i = 0; i < stringBuffer.length() && (n4 = inputStream.read()) != -1 && (n3 = inputStream.read()) != -1; ++i) {
                int n5 = n4 << 8 | n3;
                stringBuffer.append(n5);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
        this.setParameter(n, stringBuffer.toString());
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(34, iOException.getMessage());
        }
        this.setBytes(n, byArray);
    }

    public void clearParameters() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.vParameter.removeAllElements();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (object == null) {
            this.setNull(n);
            return;
        }
        if (n2 != 1111) {
            object = Column.convertObject(object, n2);
        }
        this.setObjectInType(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (object == null) {
            this.setNull(n);
            return;
        }
        int n2 = 1111;
        if (object instanceof String) {
            n2 = 12;
        } else if (object instanceof BigDecimal) {
            n2 = 2;
        } else if (object instanceof Integer) {
            n2 = 4;
        } else if (object instanceof Long) {
            n2 = -5;
        } else if (object instanceof Float) {
            n2 = 7;
        } else if (object instanceof Double) {
            n2 = 8;
        } else if (object instanceof byte[]) {
            n2 = -2;
        } else if (object instanceof Date) {
            n2 = 91;
        } else if (object instanceof Time) {
            n2 = 92;
        } else if (object instanceof Timestamp) {
            n2 = 93;
        } else if (object instanceof Boolean) {
            n2 = -7;
        } else if (object instanceof Byte) {
            n2 = -6;
        } else if (object instanceof Short) {
            n2 = 5;
        }
        this.setObjectInType(n, object, n2);
    }

    public boolean execute() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return super.execute(this.build());
    }

    public void addBatch() throws SQLException {
        throw this.getNotSupported();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        char[] cArray = new char[n2];
        try {
            int n3 = reader.read(cArray);
            if (n3 == -1) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
        this.setString(n, new String(cArray));
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw this.getNotSupported();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw this.getNotSupported();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw this.getNotSupported();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (date == null) {
            this.setNull(n);
        } else {
            String string = HsqlDateTime.getDateString(date, calendar);
            this.setParameter(n, Column.createSQLString(string));
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (time == null) {
            this.setNull(n);
        } else {
            String string = HsqlDateTime.getTimeString(time, calendar);
            this.setParameter(n, Column.createSQLString(string));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (timestamp == null) {
            this.setNull(n);
        } else {
            String string = HsqlDateTime.getTimestampString(timestamp, calendar);
            this.setParameter(n, Column.createSQLString(string));
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean wasNull() throws SQLException {
        throw this.getNotSupported();
    }

    public String getString(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public boolean getBoolean(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public byte getByte(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public short getShort(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public int getInt(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public long getLong(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public float getFloat(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public double getDouble(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw this.getNotSupported();
    }

    public byte[] getBytes(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Time getTime(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw this.getNotSupported();
    }

    public Ref getRef(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Blob getBlob(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Clob getClob(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Array getArray(int n) throws SQLException {
        throw this.getNotSupported();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String string = this.getParameter(n);
        string = string.substring(1, string.length() - 1);
        return HsqlDateTime.getDate(string, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String string = this.getParameter(n);
        string = string.substring(1, string.length() - 1);
        return HsqlDateTime.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        String string = this.getParameter(n);
        string = string.substring(1, string.length() - 1);
        return HsqlDateTime.getTimestamp(string, calendar);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw this.getNotSupported();
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public URL getURL(int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setNull(String string, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setShort(String string, short s) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setInt(String string, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setLong(String string, long l) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setString(String string, String string2) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public String getString(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public byte getByte(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public short getShort(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public int getInt(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public long getLong(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public float getFloat(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public double getDouble(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Date getDate(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Time getTime(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Object getObject(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Ref getRef(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Blob getBlob(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Clob getClob(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Array getArray(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public URL getURL(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string) {
        super(jdbcConnection2);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n) {
        super(jdbcConnection2, n);
        this.sSql = string;
        this.vParameter = new Vector();
    }

    private String build() {
        if (this.vParameter.isEmpty()) {
            return this.sSql;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.sSql.length();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            char c = this.sSql.charAt(i);
            if (c == '?' && !bl && !bl2) {
                stringBuffer.append(this.getParameter(n++));
                continue;
            }
            if (c == '\'' && !bl2) {
                bl = !bl;
            } else if (c == '\"' && !bl) {
                bl2 = !bl2;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private String getParameter(int n) {
        if (n >= this.vParameter.size()) {
            return null;
        }
        return (String)this.vParameter.elementAt(n);
    }

    private SQLException invalidValue() {
        return Trace.error(11);
    }

    private void setNull(int n) {
        this.setParameter(n, "NULL");
    }

    private void setObjectInType(int n, Object object, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (object == null) {
            this.setNull(n);
            return;
        }
        switch (n2) {
            case -7: {
                this.setBoolean(n, (boolean)((Boolean)object));
                break;
            }
            case -6: {
                this.setByte(n, ((Number)object).byteValue());
                break;
            }
            case 5: {
                this.setShort(n, ((Number)object).shortValue());
                break;
            }
            case 4: {
                this.setInt(n, ((Number)object).intValue());
                break;
            }
            case -5: {
                this.setLong(n, ((Number)object).longValue());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.setDouble(n, ((Number)object).doubleValue());
                break;
            }
            case 2: {
                this.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, (String)object);
                break;
            }
            case 91: {
                this.setDate(n, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n, (byte[])object);
                break;
            }
            case 1111: {
                this.setParameter(n, Column.createSQLString(ByteArray.serializeToString(object)));
                break;
            }
            default: {
                this.setParameter(n, object.toString());
            }
        }
    }

    private void setParameter(int n, String string) {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.vParameter.size() < n) {
            this.vParameter.setSize(n);
        }
        this.vParameter.setElementAt(string, --n);
    }
}

