/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcDatabaseMetaData;
import org.hsqldb.jdbcPreparedStatement;
import org.hsqldb.jdbcResultSet;
import org.hsqldb.jdbcStatement;

public class jdbcConnection
implements Connection {
    private boolean bClosed;
    private String sDatabaseName;
    private HsqlProperties connProperties;
    static final int HTTP = 0;
    static final int STANDALONE = 1;
    static final int INTERNAL = 2;
    static final int HSQLDB = 3;
    private int iType;
    Database dDatabase;
    Session cSession;
    private static Hashtable tDatabase = new Hashtable();
    private static Hashtable iUsageCount = new Hashtable();
    Socket sSocket;
    DataOutputStream dOutput;
    DataInputStream dInput;
    public static final int DEFAULT_HSQLDB_PORT = 9001;
    private String sConnect;
    private String sUser;
    private String sPassword;
    static final String ENCODING = "8859_1";
    static /* synthetic */ Class class$org$hsqldb$jdbcConnection;

    public Statement createStatement() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return new jdbcStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        this.checkClosed();
        return new jdbcPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        this.checkClosed();
        return new jdbcPreparedStatement(this, string);
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string.indexOf(123) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = cArray.length;
        block7: for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        continue block7;
                    }
                    if (c == '\"') {
                        n = 2;
                        continue block7;
                    }
                    if (c != '{') continue block7;
                    cArray[i] = 32;
                    bl = true;
                    String string2 = string.substring(i + 1).toUpperCase();
                    if (string2.startsWith("?=")) {
                        i += 2;
                    } else if (string2.startsWith("CALL")) {
                        i += 4;
                    } else if (string2.startsWith("ESCAPE")) {
                        i += 6;
                    }
                    n = 3;
                    continue block7;
                }
                case 1: 
                case 5: {
                    if (c != '\'') continue block7;
                    --n;
                    continue block7;
                }
                case 2: 
                case 6: {
                    if (c != '\"') continue block7;
                    n -= 2;
                    continue block7;
                }
                case 3: {
                    if (c == ' ') {
                        n = 4;
                        continue block7;
                    }
                    cArray[i] = 32;
                    bl = true;
                    continue block7;
                }
                case 4: {
                    if (c == '\'') {
                        n = 5;
                        continue block7;
                    }
                    if (c == '\"') {
                        n = 6;
                        continue block7;
                    }
                    if (c != '}') continue block7;
                    cArray[i] = 32;
                    bl = true;
                    n = 0;
                }
            }
        }
        if (bl) {
            string = new String(cArray);
            if (Trace.TRACE) {
                Trace.trace(cArray + " > " + string);
            }
        }
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.execute("SET AUTOCOMMIT " + (bl ? "TRUE" : "FALSE"));
    }

    public boolean getAutoCommit() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.iType == 2 || this.iType == 1) {
            return this.cSession.getAutoCommit();
        }
        try {
            jdbcResultSet jdbcResultSet2 = this.execute("call \"org.hsqldb.Library.getAutoCommit\"()");
            jdbcResultSet2.next();
            return jdbcResultSet2.getBoolean(1);
        }
        catch (SQLException sQLException) {
            this.close();
            throw Trace.error(3);
        }
    }

    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    public void rollback() throws SQLException {
        this.execute("ROLLBACK");
    }

    public void close() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.iType == 2) {
            return;
        }
        if (this.bClosed) {
            return;
        }
        if (this.iType == 1) {
            this.closeStandalone();
        } else {
            this.execute("DISCONNECT");
        }
        this.bClosed = true;
    }

    public boolean isClosed() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.bClosed;
    }

    public DatabaseMetaData getMetaData() {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return new jdbcDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.execute("SET READONLY " + (bl ? "TRUE" : "FALSE"));
    }

    public boolean isReadOnly() throws SQLException {
        String string = "SELECT * FROM SYSTEM_CONNECTIONINFO WHERE KEY='READONLY'";
        jdbcResultSet jdbcResultSet2 = this.execute(string);
        jdbcResultSet2.next();
        return jdbcResultSet2.getString(2).equals("TRUE");
    }

    public void setCatalog(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
    }

    public String getCatalog() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(n);
        }
        if (n != 1) {
            throw Trace.error(20);
        }
        this.checkClosed();
    }

    public int getTransactionIsolation() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return 1;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        return null;
    }

    static void checkTypeConcurrency(int n, int n2) throws SQLException {
        if (n != 1003 && n != 1004 || n2 != 1007) {
            throw Trace.error(20);
        }
    }

    void checkClosed() throws SQLException {
        if (this.bClosed) {
            throw Trace.error(2);
        }
    }

    static void removeDatabase(Database database) {
        if (database == null) {
            return;
        }
        Database database2 = (Database)tDatabase.get(database.getName());
        if (database.equals(database2)) {
            tDatabase.remove(database.getName());
            iUsageCount.remove(database);
        }
    }

    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkClosed();
        jdbcConnection.checkTypeConcurrency(n, n2);
        return new jdbcStatement(this, n);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        jdbcConnection.checkTypeConcurrency(n, n2);
        this.checkClosed();
        return new jdbcPreparedStatement(this, string, n);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        jdbcConnection.checkTypeConcurrency(n, n2);
        this.checkClosed();
        return this.prepareCall(string);
    }

    public Map getTypeMap() throws SQLException {
        throw Trace.error(20);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw Trace.error(20);
    }

    public void setHoldability(int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public int getHoldability() throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw Trace.error(20, "JDBC3");
    }

    jdbcConnection(String string, Properties properties) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        String string2 = (String)properties.get("user");
        String string3 = (String)properties.get("password");
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.sDatabaseName = string;
        if ((string = string.toUpperCase()).startsWith("HTTP://")) {
            this.iType = 0;
            this.openHTTP(string2, string3);
        } else if (string.startsWith("HSQL://")) {
            this.iType = 3;
            this.openHSQL(string2, string3);
        } else {
            this.iType = 1;
            this.openStandalone(string2, string3);
        }
        this.connProperties = new HsqlProperties(properties);
    }

    jdbcConnection(Session session) throws SQLException {
        Trace.doAssert(session != null, "The specified Session is null");
        this.iType = 2;
        this.cSession = session;
        this.dDatabase = session.getDatabase();
        this.sDatabaseName = this.dDatabase.getName();
    }

    jdbcResultSet execute(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        this.checkClosed();
        if (this.iType == 0) {
            return this.executeHTTP(string);
        }
        if (this.iType == 3) {
            return this.executeHSQL(string);
        }
        return this.executeStandalone(string);
    }

    boolean usesLocalFiles() {
        return this.iType != 0;
    }

    String getName() {
        return this.sDatabaseName;
    }

    private void openHTTP(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName;
        this.sUser = string;
        this.sPassword = string2;
        this.executeHTTP(" ");
    }

    private synchronized jdbcResultSet executeHTTP(String string) throws SQLException {
        byte[] byArray;
        try {
            URL uRL = new URL(this.sConnect);
            String string2 = StringConverter.unicodeToHexString(this.sUser);
            string2 = string2 + "+" + StringConverter.unicodeToHexString(this.sPassword);
            string2 = string2 + "+" + StringConverter.unicodeToHexString(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(string2.getBytes(ENCODING));
            outputStream.close();
            uRLConnection.connect();
            InputStream inputStream = (InputStream)uRLConnection.getContent();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n = uRLConnection.getContentLength();
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                int n2 = bufferedInputStream.read();
                byArray[i] = (byte)n2;
            }
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray), this.connProperties);
    }

    private void openHSQL(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName.substring(7);
        this.sUser = string;
        this.sPassword = string2;
        this.reconnectHSQL();
    }

    private void reconnectHSQL() throws SQLException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.sConnect, ":");
            String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            int n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 9001;
            this.sSocket = new Socket(string, n);
            this.sSocket.setTcpNoDelay(true);
            this.dOutput = new DataOutputStream(new BufferedOutputStream(this.sSocket.getOutputStream()));
            this.dInput = new DataInputStream(new BufferedInputStream(this.sSocket.getInputStream()));
            this.dOutput.writeUTF(this.sUser);
            this.dOutput.writeUTF(this.sPassword);
            this.dOutput.flush();
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
    }

    private synchronized jdbcResultSet executeHSQL(String string) throws SQLException {
        byte[] byArray;
        try {
            int n;
            byte[] byArray2 = string.getBytes("utf-8");
            this.dOutput.writeInt(byArray2.length);
            this.dOutput.write(byArray2);
            this.dOutput.flush();
            int n2 = this.dInput.readInt();
            byArray = new byte[n2];
            int n3 = 0;
            while ((n = this.dInput.read(byArray, n3, n2)) != n2) {
                n2 -= n;
                n3 += n;
            }
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray), this.connProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStandalone(String string, String string2) throws SQLException {
        Class clazz = class$org$hsqldb$jdbcConnection == null ? (class$org$hsqldb$jdbcConnection = jdbcConnection.class$("org.hsqldb.jdbcConnection")) : class$org$hsqldb$jdbcConnection;
        synchronized (clazz) {
            int n;
            this.dDatabase = (Database)tDatabase.get(this.sDatabaseName);
            if (this.dDatabase == null) {
                this.dDatabase = new Database(this.sDatabaseName);
                tDatabase.put(this.sDatabaseName, this.dDatabase);
                n = 1;
            } else {
                n = 1 + (Integer)iUsageCount.get(this.sDatabaseName);
            }
            iUsageCount.put(this.sDatabaseName, new Integer(n));
            this.cSession = this.dDatabase.connect(string, string2);
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStandalone() throws SQLException {
        Class clazz = class$org$hsqldb$jdbcConnection == null ? (class$org$hsqldb$jdbcConnection = jdbcConnection.class$("org.hsqldb.jdbcConnection")) : class$org$hsqldb$jdbcConnection;
        synchronized (clazz) {
            Integer n = (Integer)iUsageCount.get(this.sDatabaseName);
            if (n == null) {
                return;
            }
            int n2 = n - 1;
            if (n2 == 0) {
                iUsageCount.remove(this.sDatabaseName);
                tDatabase.remove(this.sDatabaseName);
                if (!this.dDatabase.isShutdown()) {
                    this.execute("SHUTDOWN");
                }
                this.dDatabase = null;
                this.cSession = null;
            } else {
                iUsageCount.put(this.sDatabaseName, new Integer(n2));
                this.execute("DISCONNECT");
            }
        }
    }

    private jdbcResultSet executeStandalone(String string) throws SQLException {
        return new jdbcResultSet(this.dDatabase.execute(string, this.cSession), this.connProperties);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

