/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.Trace;

class Tokenizer {
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int QUOTED_IDENTIFIER = 9;
    private static final int REMARK_LINE = 10;
    private static final int REMARK = 11;
    private String sCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private String sLongNameLast;
    private boolean bWait;
    private static Hashtable hKeyword = new Hashtable(67);

    Tokenizer(String string) {
        this.sCommand = string;
        this.iLength = string.length();
        this.iIndex = 0;
    }

    void back() throws SQLException {
        Trace.doAssert(!this.bWait, "back");
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.tokenIndex;
        this.bWait = true;
    }

    void getThis(String string) throws SQLException {
        this.getToken();
        if (!this.sToken.equals(string)) {
            throw Trace.error(11, this.sToken);
        }
    }

    String getStringToken() throws SQLException {
        this.getToken();
        if (this.iType == 6) {
            return this.sToken.toUpperCase();
        }
        if (this.iType == 1) {
            return this.sToken;
        }
        if (this.iType == 9) {
            return this.sToken.toUpperCase();
        }
        throw Trace.error(11, this.sToken);
    }

    boolean wasValue() {
        if (this.iType == 6 || this.iType == 4 || this.iType == 5 || this.iType == 7 || this.iType == 8) {
            return true;
        }
        return this.sToken.equals("NULL") || this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }

    boolean wasQuotedIdentifier() {
        return this.iType == 9;
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 9) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !hKeyword.containsKey(this.sToken);
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getLongNameLast() {
        return this.sLongNameLast;
    }

    String getName() throws SQLException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    String getString() throws SQLException {
        this.getToken();
        return this.sToken;
    }

    int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    Object getAsValue() throws SQLException {
        if (!this.wasValue()) {
            throw Trace.error(11, this.sToken);
        }
        if (this.iType == 6) {
            return this.sToken;
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 4) {
            if (this.sToken.length() < 10) {
                return new Integer(this.sToken);
            }
            if (this.sToken.length() == 10) {
                try {
                    return new Integer(this.sToken);
                }
                catch (Exception exception) {
                    this.iType = 7;
                    return new Long(this.sToken);
                }
            }
            if (this.sToken.length() < 19) {
                this.iType = 7;
                return new Long(this.sToken);
            }
            if (this.sToken.length() == 19) {
                try {
                    return new Long(this.sToken);
                }
                catch (Exception exception) {
                    this.iType = 8;
                    return new BigDecimal(this.sToken);
                }
            }
            this.iType = 8;
            return new BigDecimal(this.sToken);
        }
        if (this.iType == 5) {
            return new Double(this.sToken);
        }
        if (this.iType == 8) {
            return new BigDecimal(this.sToken);
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int n, int n2) {
        return this.sCommand.substring(n, n2);
    }

    int getPartMarker() {
        return this.beginIndex;
    }

    void setPartMarker() {
        this.beginIndex = this.iIndex;
    }

    void setPartMarker(int n) {
        this.beginIndex = n;
    }

    String getLastPart() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    private void getToken() throws SQLException {
        if (this.bWait) {
            this.bWait = false;
            this.iIndex = this.nextTokenIndex;
            return;
        }
        while (this.iIndex < this.iLength && Character.isWhitespace(this.sCommand.charAt(this.iIndex))) {
            ++this.iIndex;
        }
        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        char c = this.sCommand.charAt(this.iIndex);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        char c2 = '\u0000';
        if (Character.isJavaIdentifierStart(c)) {
            this.iType = 1;
        } else if (Character.isDigit(c)) {
            this.iType = 4;
            bl2 = true;
        } else {
            switch (c) {
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '=': {
                    this.iType = 3;
                    ++this.iIndex;
                    this.sToken = String.valueOf(c);
                    return;
                }
                case '\"': {
                    this.iType = 9;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    c = this.sCommand.charAt(this.iIndex);
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        StringBuffer stringBuffer = new StringBuffer(this.sLongNameFirst.length() + 1 + this.sLongNameLast.length());
                        stringBuffer.append(this.sLongNameFirst);
                        stringBuffer.append('.');
                        stringBuffer.append(this.sLongNameLast);
                        this.sToken = stringBuffer.toString();
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    c2 = c;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    bl = true;
                    break;
                }
                default: {
                    throw Trace.error(11, String.valueOf(c));
                }
            }
        }
        int n = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c = ' ';
                bl5 = true;
                Trace.check(this.iType != 6 && this.iType != 9, 12);
            } else {
                c = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.sToken = this.sCommand.substring(n, this.iIndex).toUpperCase();
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        this.sToken = this.sLongNameFirst + "." + this.sLongNameLast;
                    }
                    return;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 11: {
                    if (bl5) {
                        this.iType = 0;
                        return;
                    }
                    if (c != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 10: {
                    if (bl5) {
                        this.iType = 0;
                        return;
                    }
                    if (c != '\r' && c != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (c == '/' && c2 == '/') {
                        this.iType = 10;
                        break;
                    }
                    if (c == '-' && c2 == '-') {
                        this.iType = 10;
                        break;
                    }
                    if (c == '*' && c2 == '/') {
                        this.iType = 11;
                        break;
                    }
                    if (c == '>' || c == '=' || c == '|') break;
                    this.sToken = this.sCommand.substring(n, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(c)) {
                        bl2 = true;
                        break;
                    }
                    if (c == '.') {
                        this.iType = 8;
                        if (bl) {
                            throw Trace.error(11, ".");
                        }
                        bl = true;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        if (bl3) {
                            throw Trace.error(11, "E");
                        }
                        this.iType = 5;
                        bl4 = true;
                        bl = true;
                        bl3 = true;
                        break;
                    }
                    if (c == '-' && bl4) {
                        bl4 = false;
                        break;
                    }
                    if (c == '+' && bl4) {
                        bl4 = false;
                        break;
                    }
                    bl4 = false;
                    if (!bl2) {
                        if (bl && n == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(11, String.valueOf(c));
                    }
                    this.sToken = this.sCommand.substring(n, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char c) throws SQLException {
        try {
            int n = this.iIndex;
            boolean bl = false;
            while (true) {
                if ((n = this.sCommand.indexOf(c, n)) < 0) {
                    throw Trace.error(12);
                }
                if (n >= this.iLength - 1 || this.sCommand.charAt(n + 1) != c) break;
                bl = true;
                n += 2;
            }
            char[] cArray = new char[n - this.iIndex];
            this.sCommand.getChars(this.iIndex, n, cArray, 0);
            int n2 = cArray.length;
            if (bl) {
                n2 = 0;
                int n3 = 0;
                while (n3 < cArray.length) {
                    if (cArray[n3] == c) {
                        ++n3;
                    }
                    cArray[n2] = cArray[n3];
                    ++n3;
                    ++n2;
                }
            }
            this.iIndex = ++n;
            return new String(cArray, 0, n2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            exception.getMessage();
            return null;
        }
    }

    void setString(String string, int n) {
        this.sCommand = string;
        this.iLength = string.length();
        this.bWait = false;
        this.iIndex = n;
    }

    int getLength() {
        return this.iLength;
    }

    static {
        String[] stringArray = new String[]{"AND", "ALL", "AVG", "BY", "BETWEEN", "COUNT", "CASEWHEN", "DISTINCT", "EXISTS", "EXCEPT", "FALSE", "FROM", "GROUP", "IF", "INTO", "IFNULL", "IS", "IN", "INTERSECT", "INNER", "LEFT", "LIKE", "MAX", "MIN", "NULL", "NOT", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "SELECT", "SET", "SUM", "TO", "TRUE", "UNIQUE", "UNION", "VALUES", "WHERE", "CONVERT", "CAST", "CONCAT", "MINUS", "CALL"};
        for (int i = 0; i < stringArray.length; ++i) {
            hKeyword.put(stringArray[i], hKeyword);
        }
    }
}

