/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class TableWorks {
    private Table table;

    TableWorks(Table table) {
        this.table = table;
    }

    Table getTable() {
        return this.table;
    }

    void createForeignKey(int[] nArray, int[] nArray2, HsqlName hsqlName, Table table, boolean bl) throws SQLException {
        Object object;
        HsqlName hsqlName2;
        Index index;
        if (this.table.getConstraint(hsqlName.name) != null) {
            throw Trace.error(60);
        }
        int n = this.table.dDatabase.getTableIndex(this.table) - this.table.dDatabase.getTableIndex(table);
        Index index2 = n == 0 ? table.getConstraintIndexForColumns(nArray2, true) : table.getIndexForColumns(nArray2, true);
        boolean bl2 = this.table.dDatabase.getProperties().isPropertyTrue("sql.strict_fk");
        boolean bl3 = bl2 = bl2 || !table.isTemp() && this.table.isTemp();
        if (table.isTemp() && !this.table.isTemp()) {
            throw Trace.error(47, "referenced table cannot be TEMPORARY");
        }
        if (bl2 && (index2 == null || !index2.isUnique())) {
            throw Trace.error(26, "needs unique index on referenced columns of " + table.getName().statementName);
        }
        Index index3 = index = n >= 0 ? this.table.getConstraintIndexForColumns(nArray, false) : this.table.getIndexForColumns(nArray, false);
        if (index == null) {
            HsqlName hsqlName3 = HsqlName.makeAutoName("IDX");
            index = this.createIndex(nArray, hsqlName3, false);
        }
        boolean bl4 = this.table.dDatabase.getProperties().isPropertyTrue("sql.strong_fk");
        if (index2 == null || bl4 && !index2.isUnique()) {
            hsqlName2 = HsqlName.makeAutoName("FK");
            object = new TableWorks(table);
            index2 = ((TableWorks)object).createIndex(nArray2, hsqlName2, bl4);
            table = ((TableWorks)object).getTable();
        }
        hsqlName2 = HsqlName.makeAutoName("REF", hsqlName.name);
        object = new Constraint(hsqlName2, hsqlName, table, this.table, nArray2, nArray, index2, index, bl);
        this.table.addConstraint((Constraint)object);
        table.addConstraint(new Constraint(hsqlName2, (Constraint)object));
    }

    Index createIndex(int[] nArray, HsqlName hsqlName, boolean bl) throws SQLException {
        if (this.table.isEmpty()) {
            return this.table.createIndexPrivate(nArray, hsqlName, bl);
        }
        Table table = this.table.moveDefinition(null, null, this.table.getColumnCount(), 0);
        Index index = table.createIndexPrivate(nArray, hsqlName, bl);
        table.moveData(this.table, this.table.getColumnCount(), 0);
        table.updateConstraints(this.table, this.table.getColumnCount(), 0);
        int n = this.table.dDatabase.getTableIndex(this.table);
        this.table.dDatabase.getTables().setElementAt(table, n);
        this.table = table;
        return index;
    }

    void createUniqueConstraint(int[] nArray, HsqlName hsqlName) throws SQLException {
        Object object;
        Vector vector = this.table.getConstraints();
        for (int i = 0; i < vector.size(); ++i) {
            object = (Constraint)vector.elementAt(i);
            if (!((Constraint)object).isEquivalent(nArray, 2) && !((Constraint)object).getName().name.equals(hsqlName.name)) continue;
            throw Trace.error(60);
        }
        HsqlName hsqlName2 = HsqlName.makeAutoName("IDX");
        object = this.createIndex(nArray, hsqlName2, true);
        Constraint constraint = new Constraint(hsqlName, this.table, (Index)object);
        this.table.addConstraint(constraint);
    }

    void dropIndex(String string) throws SQLException {
        Table table = this.table.moveDefinition(string, null, this.table.getColumnCount(), 0);
        table.moveData(this.table, this.table.getColumnCount(), 0);
        table.updateConstraints(this.table, this.table.getColumnCount(), 0);
        int n = this.table.dDatabase.getTableIndex(this.table);
        this.table.dDatabase.getTables().setElementAt(table, n);
        this.table = table;
    }

    void addOrDropColumn(Column column, int n, int n2) throws SQLException {
        Table table = this.table.moveDefinition(null, column, n, n2);
        table.moveData(this.table, n, n2);
        table.updateConstraints(this.table, n, n2);
        int n3 = this.table.dDatabase.getTableIndex(this.table);
        this.table.dDatabase.getTables().setElementAt(table, n3);
        this.table = table;
    }

    void dropConstraint(String string) throws SQLException {
        int n = this.table.getConstraintIndex(string);
        Constraint constraint = this.table.getConstraint(string);
        Hashtable<Constraint, Constraint> hashtable = new Hashtable<Constraint, Constraint>();
        hashtable.put(constraint, constraint);
        if (constraint == null) {
            throw Trace.error(61, string + " in table: " + this.table.getName().name);
        }
        if (constraint.getType() == 1) {
            throw Trace.error(59);
        }
        if (constraint.getType() == 0) {
            Index index;
            int n2;
            Table table;
            block12: {
                table = constraint.getMain();
                Constraint constraint2 = table.getConstraint(constraint.getPkName());
                hashtable.put(constraint2, constraint2);
                n2 = table.getConstraintIndex(constraint.getPkName());
                Index index2 = constraint2.getMainIndex();
                if (index2.getName().isReservedName()) {
                    boolean bl = false;
                    try {
                        table.checkDropIndex(index2.getName().name, hashtable);
                        bl = true;
                        TableWorks tableWorks = new TableWorks(table);
                        tableWorks.dropIndex(index2.getName().name);
                        if (table == this.table) {
                            this.table = tableWorks.getTable();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!bl) break block12;
                        throw sQLException;
                    }
                }
            }
            if ((index = constraint.getRefIndex()).getName().isReservedName()) {
                try {
                    this.table.checkDropIndex(index.getName().name, hashtable);
                    this.dropIndex(index.getName().name);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            table.vConstraint.removeElementAt(n2);
            this.table.vConstraint.removeElementAt(n);
        } else if (constraint.getType() == 2) {
            this.table.checkDropIndex(constraint.getMainIndex().getName().name, hashtable);
            this.dropIndex(constraint.getMainIndex().getName().name);
            this.table.vConstraint.removeElementAt(n);
        }
    }
}

