/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;

class Table {
    static final int SYSTEM_TABLE = 0;
    static final int TEMP_TABLE = 1;
    static final int MEMORY_TABLE = 2;
    static final int CACHED_TABLE = 3;
    static final int TEMP_TEXT_TABLE = 4;
    static final int TEXT_TABLE = 5;
    static final int VIEW = 6;
    static final String DEFAULT_PK = "";
    private Vector vColumn;
    private Vector vIndex;
    private int[] iPrimaryKey;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    Vector vConstraint;
    Vector[] vTrigs;
    private int[] colTypes;
    private boolean isSystem;
    private boolean isText;
    private boolean isView;
    protected int iColumnCount;
    protected int iVisibleColumns;
    protected Database dDatabase;
    protected Cache cCache;
    protected HsqlName tableName;
    protected int tableType;
    protected Session ownerSession;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;

    Table(Database database, HsqlName hsqlName, int n, Session session) throws SQLException {
        this.dDatabase = database;
        if (n == 0) {
            this.isTemp = true;
        } else if (n == 1) {
            Trace.doAssert(session != null);
            this.isTemp = true;
            this.ownerSession = session;
        } else if (n == 3) {
            this.cCache = database.logger.getCache();
            if (this.cCache != null) {
                this.isCached = true;
            } else {
                n = 2;
            }
        } else if (n == 4) {
            Trace.doAssert(session != null);
            if (!database.logger.hasLog()) {
                throw Trace.error(63);
            }
            this.isTemp = true;
            this.isText = true;
            this.isReadOnly = true;
            this.isCached = true;
            this.ownerSession = session;
        } else if (n == 5) {
            if (!database.logger.hasLog()) {
                throw Trace.error(63);
            }
            this.isText = true;
            this.isCached = true;
        } else if (n == 6) {
            this.isView = true;
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.iPrimaryKey = null;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
        this.vTrigs = new Vector[TriggerDef.numTrigs()];
        for (int i = 0; i < TriggerDef.numTrigs(); ++i) {
            this.vTrigs[i] = new Vector();
        }
    }

    boolean equals(String string, Session session) {
        if (this.isTemp && session.getId() != this.ownerSession.getId()) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    final boolean isText() {
        return this.isText;
    }

    final boolean isTemp() {
        return this.isTemp;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void setDataReadOnly(boolean bl) throws SQLException {
        this.isReadOnly = bl;
    }

    Session getOwnerSession() {
        return this.ownerSession;
    }

    protected void setDataSource(String string, boolean bl, Session session) throws SQLException {
        throw Trace.error(22);
    }

    protected String getDataSource() throws SQLException {
        return null;
    }

    protected boolean isDescDataSource() throws SQLException {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.vConstraint.addElement(constraint);
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    Index getConstraintIndexForColumns(int[] nArray, boolean bl) {
        Index index = this.getPrimaryIndex();
        if (ArrayUtil.haveEquality(index.getColumns(), nArray, nArray.length, bl)) {
            return index;
        }
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
            index = constraint.getMainIndex();
            if (!ArrayUtil.haveEquality(index.getColumns(), nArray, nArray.length, bl)) continue;
            return index;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        for (int i = n; i < this.vConstraint.size(); ++i) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
            if (constraint.getType() != n2) continue;
            return i;
        }
        return -1;
    }

    void addColumn(String string, int n) throws SQLException {
        Column column = new Column(new HsqlName(string, false), true, n, 0, 0, false, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws SQLException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4, 16, column.columnName.name);
            Trace.check(this.iIdentityColumn == -1, 24, column.columnName.name);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.doAssert(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.addElement(column);
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        for (int i = 0; i < result.getColumnCount(); ++i) {
            Column column = new Column(new HsqlName(result.sLabel[i], result.isLabelQuoted[i]), true, result.colType[i], result.colSize[i], result.colScale[i], false, false, null);
            this.addColumn(column);
        }
    }

    HsqlName getName() {
        return this.tableName;
    }

    void setName(String string, boolean bl) {
        this.tableName.rename(string, bl);
        if (HsqlName.isReservedName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    protected Table duplicate() throws SQLException {
        Table table = new Table(this.dDatabase, this.tableName, this.tableType, this.ownerSession);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws SQLException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.iColumnCount || nArray2[i] >= table.iColumnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[i]).getType() == table.getColumn(nArray2[i]).getType()) continue;
            throw Trace.error(57);
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws SQLException {
        int[] nArray;
        Table table = this.duplicate();
        for (int i = 0; i < this.iVisibleColumns + 1; ++i) {
            if (i == n) {
                if (n2 > 0) {
                    table.addColumn(column);
                } else if (n2 < 0) continue;
            }
            if (i == this.iVisibleColumns) break;
            table.addColumn(this.getColumn(i));
        }
        int[] nArray2 = nArray = this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray);
        table.vConstraint = this.vConstraint;
        for (int i = 1; i < this.getIndexCount(); ++i) {
            Index index;
            Index index2 = this.getIndex(i);
            if (string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null) continue;
            throw Trace.error(23);
        }
        return table;
    }

    void updateConstraints(Table table, int n, int n2) throws SQLException {
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
            constraint.replaceTable(table, this, n, n2);
        }
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        for (int i = 0; i < this.iColumnCount; ++i) {
            if (!string.equals(((Column)this.vColumn.elementAt((int)i)).columnName.name)) continue;
            return i;
        }
        return -1;
    }

    Index getPrimaryIndex() {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int n) throws SQLException {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index index = this.getIndex(i);
            if (index.getColumns()[0] != n) continue;
            return index;
        }
        return null;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws SQLException {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index index = this.getIndex(i);
            int[] nArray2 = index.getColumns();
            if (!ArrayUtil.haveEquality(nArray2, nArray, nArray.length, bl) || bl && !index.isUnique()) continue;
            return index;
        }
        return null;
    }

    int[] getIndexRootsArray() throws SQLException {
        int[] nArray = new int[this.iIndexCount];
        for (int i = 0; i < this.iIndexCount; ++i) {
            Node node = this.getIndex(i).getRoot();
            nArray[i] = node != null ? node.getKey() : -1;
        }
        return nArray;
    }

    String getIndexRoots() throws SQLException {
        Trace.doAssert(this.isCached, "Table.getIndexRootData");
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.iIdentityId);
        return stringBuffer.toString();
    }

    void setIndexRoots(int[] nArray) throws SQLException {
        Trace.check(this.isCached, 22);
        for (int i = 0; i < this.iIndexCount; ++i) {
            int n = nArray[i];
            CachedRow cachedRow = null;
            if (n != -1) {
                cachedRow = this.cCache.getRow(n, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = ((Row)cachedRow).getNode(i);
            }
            this.getIndex(i).setRoot(node);
        }
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.isCached, 22);
        int[] nArray = new int[this.iIndexCount];
        int n = 0;
        for (int i = 0; i < this.iIndexCount; ++i) {
            int n2;
            int n3 = string.indexOf(32, n);
            nArray[i] = n2 = Integer.parseInt(string.substring(n, n3));
            n = n3 + 1;
        }
        this.setIndexRoots(nArray);
        this.iIdentityId = Integer.parseInt(string.substring(n));
    }

    Index getNextIndex(Index index) {
        int n;
        if (index != null) {
            for (n = 0; n < this.iIndexCount && this.getIndex(n) != index; ++n) {
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    void createPrimaryKey() throws SQLException {
        this.createPrimaryKey(null, null);
    }

    void createPrimaryKey(HsqlName hsqlName, int[] nArray) throws SQLException {
        Object object;
        Trace.doAssert(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        if (nArray == null) {
            nArray = new int[]{this.iColumnCount};
            object = new Column(new HsqlName(DEFAULT_PK, false), false, 4, 0, 0, true, true, null);
            this.addColumn((Column)object);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.getColumn(nArray[i]).setNullable(false);
                this.getColumn(nArray[i]).setPrimaryKey(true);
            }
        }
        this.iPrimaryKey = nArray;
        object = hsqlName != null ? hsqlName : new HsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexPrivate(nArray, (HsqlName)object, true);
        this.colTypes = new int[this.iColumnCount];
        for (int i = 0; i < this.iColumnCount; ++i) {
            this.colTypes[i] = this.getColumn(i).getType();
        }
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws SQLException {
        int[] nArray = ArrayUtil.getAdjustedColumnArray(index.getColumns(), index.getVisibleColumns(), n, n2);
        if (nArray.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexPrivate(nArray, index.getName(), index.isUnique());
    }

    Index createIndexPrivate(int[] nArray, HsqlName hsqlName, boolean bl) throws SQLException {
        int n;
        Trace.doAssert(this.iPrimaryKey != null, "createIndex");
        int n2 = nArray.length;
        int n3 = this.iPrimaryKey.length;
        int[] nArray2 = new int[bl ? n2 : n2 + n3];
        int[] nArray3 = new int[bl ? n2 : n2 + n3];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n];
            nArray3[n] = this.getColumn(nArray2[n]).getType();
        }
        if (!bl) {
            for (n = 0; n < n3; ++n) {
                nArray2[n2 + n] = this.iPrimaryKey[n];
                nArray3[n2 + n] = this.getColumn(this.iPrimaryKey[n]).getType();
            }
        }
        if (nArray2[0] == this.iVisibleColumns) {
            n2 = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl, n2);
        Trace.doAssert(this.isEmpty(), "createIndex");
        this.vIndex.addElement(index);
        ++this.iIndexCount;
        return index;
    }

    void checkDropIndex(String string, Hashtable hashtable) throws SQLException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
            if (hashtable.get(constraint) != null) continue;
            if (constraint.isIndexFK(index)) {
                throw Trace.error(50, string);
            }
            if (!constraint.isIndexUnique(index)) continue;
            throw Trace.error(56, string);
        }
    }

    boolean isEmpty() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    void moveData(Table table, int n, int n2) throws SQLException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3 = null;
        if (n2 > 0) {
            object2 = this.getColumn(n);
            object3 = Column.convertObject(((Column)object2).getDefaultString(), ((Column)object2).getType());
        }
        object2 = table.getPrimaryIndex();
        Object object4 = ((Index)object2).first();
        while (object4 != null) {
            object = object4.getData();
            objectArray = this.getNewRow();
            ArrayUtil.copyAdjustArray(object, objectArray, object3, n, n2);
            this.insertNoCheck(objectArray, null, false);
            object4 = ((Index)object2).next((Node)object4);
        }
        object2 = table.getPrimaryIndex();
        object4 = ((Index)object2).first();
        while (object4 != null) {
            object = ((Index)object2).next((Node)object4);
            objectArray = object4.getData();
            table.deleteNoCheck(objectArray, null, false);
            object4 = object;
        }
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        Trace.check(!this.isReadOnly, 32);
        if (this.dDatabase.isReferentialIntegrity()) {
            for (int i = 0; i < this.vConstraint.size(); ++i) {
                Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
                constraint.checkUpdate(nArray, result, result2);
            }
        }
    }

    void insert(Result result, Session session) throws SQLException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            for (int i = 0; i < n; ++i) {
                objectArray[i] = record.data[i];
            }
            this.insert(objectArray, session);
            record = record.next;
        }
    }

    void insert(Object[] objectArray, Session session) throws SQLException {
        Trace.check(!this.isReadOnly, 32);
        this.fireAll(3, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            for (int i = 0; i < this.vConstraint.size(); ++i) {
                ((Constraint)this.vConstraint.elementAt(i)).checkInsert(objectArray);
            }
        }
        this.insertNoCheck(objectArray, session, true);
        this.fireAll(0, objectArray);
    }

    void insertNoCheck(Object[] objectArray, Session session, boolean bl) throws SQLException {
        int n;
        Object object;
        int n2;
        for (n2 = 0; n2 < this.iColumnCount; ++n2) {
            if (objectArray[n2] != null) continue;
            object = this.getColumn(n2);
            int n3 = n = ((Column)object).isNullable() || ((Column)object).isIdentity() ? 1 : 0;
            if (n != 0) continue;
            throw Trace.error(10);
        }
        n2 = this.iIdentityId;
        if (this.iIdentityColumn != -1) {
            object = (Number)objectArray[this.iIdentityColumn];
            if (object == null) {
                objectArray[this.iIdentityColumn] = new Integer(this.iIdentityId);
            } else {
                n = ((Number)object).intValue();
                if (this.iIdentityId < n) {
                    this.iIdentityId = n2 = n;
                }
            }
        }
        object = Row.newRow(this, objectArray);
        n2 = this.isText ? ((CachedRow)object).iPos + ((CachedRow)object).storageSize : ++n2;
        this.indexRow((Row)object, true);
        if (session != null) {
            session.setLastIdentity(this.iIdentityId);
            session.addTransactionInsert(this, objectArray);
        }
        this.iIdentityId = n2;
        if (bl && !this.isTemp && !this.isReadOnly && this.dDatabase.logger.hasLog()) {
            this.dDatabase.logger.writeToLog(session, this.getInsertStatement(objectArray));
        }
    }

    void fireAll(int n, Object[] objectArray) {
        if (!this.dDatabase.isReferentialIntegrity()) {
            return;
        }
        Vector vector = this.vTrigs[n];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            TriggerDef triggerDef = (TriggerDef)vector.elementAt(i);
            triggerDef.push(objectArray);
        }
    }

    void fireAll(int n) {
        Object[] objectArray = new Object[]{new String("Statement-level")};
        this.fireAll(n, objectArray);
    }

    void addTrigger(TriggerDef triggerDef) {
        if (Trace.TRACE) {
            Trace.trace("Trigger added " + String.valueOf(triggerDef.vectorIndx));
        }
        this.vTrigs[triggerDef.vectorIndx].addElement(triggerDef);
    }

    void checkCascadeDelete(Object[] objectArray, Session session, boolean bl) throws SQLException {
        block0: for (int i = 0; i < this.vConstraint.size(); ++i) {
            boolean bl2;
            Node node;
            Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
            if (constraint.getType() != 1 || constraint.getRef() == null || (node = constraint.findFkRef(objectArray)) == null) continue;
            Table table = constraint.getRef();
            boolean bl3 = bl2 = table.getNextConstraintIndex(0, 1) != -1;
            if (!bl && !bl2) {
                return;
            }
            Index index = constraint.getRefIndex();
            int[] nArray = constraint.getMainColumns();
            Object[] objectArray2 = new Object[nArray.length];
            ArrayUtil.copyColumnValues(objectArray, nArray, objectArray2);
            Node node2 = node;
            while (index.comparePartialRowNonUnique(objectArray2, node2.getData()) == 0) {
                Node node3 = index.next(node2);
                if (bl2) {
                    table.checkCascadeDelete(node2.getData(), session, bl);
                }
                if (bl) {
                    table.deleteNoRefCheck(node2.getData(), session);
                    if (table == this) {
                        node3 = constraint.findFkRef(objectArray);
                    }
                }
                if (node3 == null) continue block0;
                node2 = node3;
            }
        }
    }

    void delete(Object[] objectArray, Session session) throws SQLException {
        this.fireAll(10, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            this.checkCascadeDelete(objectArray, session, false);
            this.checkCascadeDelete(objectArray, session, true);
        }
        this.deleteNoCheck(objectArray, session, true);
        this.fireAll(7, objectArray);
    }

    private void deleteNoRefCheck(Object[] objectArray, Session session) throws SQLException {
        this.fireAll(10, objectArray);
        this.deleteNoCheck(objectArray, session, true);
        this.fireAll(7, objectArray);
    }

    void deleteNoCheck(Object[] objectArray, Session session, boolean bl) throws SQLException {
        for (int i = 1; i < this.iIndexCount; ++i) {
            this.getIndex(i).delete(objectArray, false);
        }
        this.getIndex(0).delete(objectArray, true);
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isReadOnly && this.dDatabase.logger.hasLog()) {
            this.dDatabase.logger.writeToLog(session, this.getDeleteStatement(objectArray));
        }
    }

    String getInsertStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.tableName.statementName);
        stringBuffer.append(" VALUES(");
        for (int i = 0; i < this.iVisibleColumns; ++i) {
            stringBuffer.append(Column.createSQLString(objectArray[i], this.getColumn(i).getType()));
            stringBuffer.append(',');
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        for (int i = 0; i < this.iIndexCount; ++i) {
            Index index = this.getIndex(i);
            if (!string.equals(index.getName().name)) continue;
            return index;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        for (int i = 0; i < this.vConstraint.size(); ++i) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(i);
            if (!constraint.getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        if (n >= 0) {
            return (Constraint)this.vConstraint.elementAt(n);
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.elementAt(n);
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return (Index)this.vIndex.elementAt(n);
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.tableName.statementName);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            for (int i = 0; i < this.iVisibleColumns; ++i) {
                Column column = this.getColumn(i);
                stringBuffer.append(column.columnName.statementName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createSQLString(objectArray[i], column.getType()));
                if (i >= this.iVisibleColumns - 1) continue;
                stringBuffer.append(" AND ");
            }
        } else {
            for (int i = 0; i < this.iPrimaryKey.length; ++i) {
                Column column = this.getColumn(this.iPrimaryKey[i]);
                stringBuffer.append(column.columnName.statementName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createSQLString(objectArray[this.iPrimaryKey[i]], column.getType()));
                if (i >= this.iPrimaryKey.length - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        return stringBuffer.toString();
    }

    Row getRow(int n) throws SQLException {
        if (this.isCached) {
            return this.cCache.getRow(n, this);
        }
        return null;
    }

    void putRow(CachedRow cachedRow) throws SQLException {
        boolean bl = false;
        if (this.cCache != null) {
            this.cCache.add(cachedRow);
        }
    }

    void removeRow(CachedRow cachedRow) throws SQLException {
        if (this.cCache != null) {
            this.cCache.free(cachedRow);
        }
    }

    void cleanUp() throws SQLException {
        if (this.cCache != null) {
            this.cCache.cleanUp();
        }
    }

    void indexRow(Row row, boolean bl) throws SQLException {
        if (bl) {
            int n;
            try {
                Node node = null;
                for (n = 0; n < this.iIndexCount; ++n) {
                    node = row.getNextNode(node);
                    this.getIndex(n).insert(node);
                }
            }
            catch (SQLException sQLException) {
                --n;
                while (n >= 0) {
                    this.getIndex(n).delete(row.getData(), n == 0);
                    --n;
                }
                throw sQLException;
            }
        }
    }
}

