/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.hsqldb.Trace;

class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    StringConverter() {
    }

    static byte[] hexToByte(String string) throws SQLException {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            int n3;
            if ((n3 = HEXINDEX.indexOf(c = string.charAt(n2++))) == -1) {
                throw Trace.error(7, "hexadecimal string contains non hex character");
            }
            int n4 = (n3 & 0xF) << 4;
            c = string.charAt(n2++);
            n3 = HEXINDEX.indexOf(c);
            byArray[i] = (byte)(n4 += n3 & 0xF);
        }
        return byArray;
    }

    static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuffer.append(HEXCHAR[n2 >> 4 & 0xF]);
            stringBuffer.append(HEXCHAR[n2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String unicodeToHexString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.byteToHex(byteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) throws SQLException {
        byte[] byArray = StringConverter.hexToByte(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static StringBuffer unicodeToAscii(String string) {
        if (string == null || string.length() == 0) {
            return new StringBuffer();
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i < n - 1 && string.charAt(i + 1) == 'u') {
                    stringBuffer.append(c);
                    stringBuffer.append("u005c");
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u");
            stringBuffer.append(HEXCHAR[c >> 12 & 0xF]);
            stringBuffer.append(HEXCHAR[c >> 8 & 0xF]);
            stringBuffer.append(HEXCHAR[c >> 4 & 0xF]);
            stringBuffer.append(HEXCHAR[c & 0xF]);
        }
        return stringBuffer;
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < n - 5) {
                char c2 = string.charAt(i + 1);
                if (c2 == 'u') {
                    ++i;
                    int n3 = HEXINDEX.indexOf(string.charAt(++i)) << 12;
                    n3 += HEXINDEX.indexOf(string.charAt(++i)) << 8;
                    n3 += HEXINDEX.indexOf(string.charAt(++i)) << 4;
                    cArray[n2++] = (char)(n3 += HEXINDEX.indexOf(string.charAt(++i)));
                    continue;
                }
                cArray[n2++] = c;
                continue;
            }
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    public static String inputStreamToString(InputStream inputStream) throws SQLException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n = 8192;
        char[] cArray = new char[n];
        try {
            int n2;
            while ((n2 = inputStreamReader.read(cArray, 0, n)) != -1) {
                stringWriter.write(cArray, 0, n2);
            }
            stringWriter.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(34, iOException.getMessage());
        }
        return stringWriter.toString();
    }

    static String toQuotedString(String string, char c, boolean bl) {
        if (string == null) {
            return "NULL";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16).append(c);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl && c2 == c) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.append(c).toString();
    }
}

