/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.User;
import org.hsqldb.jdbcConnection;

class Session {
    private Database dDatabase;
    private User uUser;
    private Vector tTransaction;
    private boolean bAutoCommit;
    private boolean bNestedTransaction;
    private boolean bNestedOldAutoCommit;
    private int iNestedOldTransIndex;
    private boolean bReadOnly;
    private int iMaxRows;
    private int iLastIdentity;
    private boolean bClosed;
    private int iId;
    private Hashtable hSavepoints;
    private boolean script;
    private jdbcConnection intConnection;

    public void finalize() throws SQLException {
        this.disconnect();
    }

    Session(Session session, int n) {
        this(session.dDatabase, session.uUser, true, session.bReadOnly, n);
    }

    Session(Database database, User user, boolean bl, boolean bl2, int n) {
        this.iId = n;
        this.dDatabase = database;
        this.uUser = user;
        this.tTransaction = new Vector();
        this.bAutoCommit = bl;
        this.bReadOnly = database.bReadOnly || bl2;
        this.hSavepoints = new Hashtable();
    }

    int getId() {
        return this.iId;
    }

    void disconnect() throws SQLException {
        if (this.bClosed) {
            return;
        }
        this.rollback();
        this.dDatabase.dropTempTables(this);
        this.dDatabase = null;
        this.uUser = null;
        this.tTransaction = null;
        this.hSavepoints = null;
        this.intConnection = null;
        this.bClosed = true;
    }

    boolean isClosed() {
        return this.bClosed;
    }

    void setLastIdentity(int n) {
        this.iLastIdentity = n;
    }

    int getLastIdentity() {
        return this.iLastIdentity;
    }

    Database getDatabase() {
        return this.dDatabase;
    }

    String getUsername() {
        return this.uUser.getName();
    }

    void setUser(User user) {
        this.uUser = user;
    }

    void checkAdmin() throws SQLException {
        this.uUser.checkAdmin();
    }

    void check(String string, int n) throws SQLException {
        this.uUser.check(string, n);
    }

    void checkReadWrite() throws SQLException {
        Trace.check(!this.bReadOnly, 31);
    }

    void setPassword(String string) {
        this.uUser.setPassword(string);
    }

    void addTransactionDelete(Table table, Object[] objectArray) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction transaction = new Transaction(true, table, objectArray);
            this.tTransaction.addElement(transaction);
        }
    }

    void addTransactionInsert(Table table, Object[] objectArray) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction transaction = new Transaction(false, table, objectArray);
            this.tTransaction.addElement(transaction);
        }
    }

    void setAutoCommit(boolean bl) throws SQLException {
        this.commit();
        this.bAutoCommit = bl;
    }

    void commit() throws SQLException {
        this.tTransaction.removeAllElements();
        this.hSavepoints.clear();
    }

    void rollback() throws SQLException {
        for (int i = this.tTransaction.size() - 1; i >= 0; --i) {
            Transaction transaction = (Transaction)this.tTransaction.elementAt(i);
            transaction.rollback();
        }
        this.tTransaction.removeAllElements();
        this.hSavepoints.clear();
    }

    void savepoint(String string) throws SQLException {
        this.hSavepoints.put(string, new Integer(this.tTransaction.size()));
    }

    void rollbackToSavepoint(String string) throws SQLException {
        Integer n = (Integer)this.hSavepoints.get(string);
        Trace.check(n != null, 44, string);
        for (int i = this.tTransaction.size() - 1; i >= n; --i) {
            Transaction transaction = (Transaction)this.tTransaction.elementAt(i);
            transaction.rollback();
            this.tTransaction.removeElementAt(i);
        }
        this.hSavepoints.remove(string);
    }

    void beginNestedTransaction() throws SQLException {
        Trace.doAssert(!this.bNestedTransaction, "beginNestedTransaction");
        this.bNestedOldAutoCommit = this.bAutoCommit;
        this.bAutoCommit = false;
        this.iNestedOldTransIndex = this.tTransaction.size();
        this.bNestedTransaction = true;
    }

    void endNestedTransaction(boolean bl) throws SQLException {
        Trace.doAssert(this.bNestedTransaction, "endNestedTransaction");
        if (bl) {
            for (int i = this.tTransaction.size() - 1; i >= this.iNestedOldTransIndex; --i) {
                Transaction transaction = (Transaction)this.tTransaction.elementAt(i);
                transaction.rollback();
            }
        }
        this.bNestedTransaction = false;
        this.bAutoCommit = this.bNestedOldAutoCommit;
        if (this.bAutoCommit) {
            this.tTransaction.setSize(this.iNestedOldTransIndex);
        }
    }

    void setReadOnly(boolean bl) {
        this.bReadOnly = bl;
    }

    boolean isReadOnly() {
        return this.bReadOnly || this.dDatabase.bReadOnly;
    }

    void setMaxRows(int n) {
        this.iMaxRows = n;
    }

    int getMaxRows() {
        return this.iMaxRows;
    }

    boolean isNestedTransaction() {
        return this.bNestedTransaction;
    }

    boolean getAutoCommit() {
        return this.bAutoCommit;
    }

    void setScripting(boolean bl) {
        this.script = bl;
    }

    boolean getScripting() {
        return this.script;
    }

    jdbcConnection getInternalConnection() throws SQLException {
        if (this.intConnection == null) {
            this.intConnection = new jdbcConnection(this);
        }
        return this.intConnection;
    }
}

